<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTrackingDocumentsReply StructType
 * Meta information extracted from the WSDL
 * - type: ns:GetTrackingDocumentsReply
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisGetTrackingDocumentsReply extends AbstractStructBase
{
    /**
     * The HighestSeverity
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $HighestSeverity;
    /**
     * The Notifications
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \cosolis\StructType\CosolisNotification[]
     */
    public $Notifications;
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var \cosolis\StructType\CosolisVersionId
     */
    public $Version;
    /**
     * The TransactionDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisTransactionDetail
     */
    public $TransactionDetail;
    /**
     * The Documents
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisTrackingDocument[]
     */
    public $Documents;
    /**
     * Constructor method for GetTrackingDocumentsReply
     * @uses CosolisGetTrackingDocumentsReply::setHighestSeverity()
     * @uses CosolisGetTrackingDocumentsReply::setNotifications()
     * @uses CosolisGetTrackingDocumentsReply::setVersion()
     * @uses CosolisGetTrackingDocumentsReply::setTransactionDetail()
     * @uses CosolisGetTrackingDocumentsReply::setDocuments()
     * @param string $highestSeverity
     * @param \cosolis\StructType\CosolisNotification[] $notifications
     * @param \cosolis\StructType\CosolisVersionId $version
     * @param \cosolis\StructType\CosolisTransactionDetail $transactionDetail
     * @param \cosolis\StructType\CosolisTrackingDocument[] $documents
     */
    public function __construct($highestSeverity = null, array $notifications = array(), \cosolis\StructType\CosolisVersionId $version = null, \cosolis\StructType\CosolisTransactionDetail $transactionDetail = null, array $documents = array())
    {
        $this
            ->setHighestSeverity($highestSeverity)
            ->setNotifications($notifications)
            ->setVersion($version)
            ->setTransactionDetail($transactionDetail)
            ->setDocuments($documents);
    }
    /**
     * Get HighestSeverity value
     * @return string
     */
    public function getHighestSeverity()
    {
        return $this->HighestSeverity;
    }
    /**
     * Set HighestSeverity value
     * @uses \cosolis\EnumType\CosolisNotificationSeverityType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisNotificationSeverityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $highestSeverity
     * @return \cosolis\StructType\CosolisGetTrackingDocumentsReply
     */
    public function setHighestSeverity($highestSeverity = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisNotificationSeverityType::valueIsValid($highestSeverity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisNotificationSeverityType', is_array($highestSeverity) ? implode(', ', $highestSeverity) : var_export($highestSeverity, true), implode(', ', \cosolis\EnumType\CosolisNotificationSeverityType::getValidValues())), __LINE__);
        }
        $this->HighestSeverity = $highestSeverity;
        return $this;
    }
    /**
     * Get Notifications value
     * @return \cosolis\StructType\CosolisNotification[]
     */
    public function getNotifications()
    {
        return $this->Notifications;
    }
    /**
     * This method is responsible for validating the values passed to the setNotifications method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNotifications method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNotificationsForArrayConstraintsFromSetNotifications(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getTrackingDocumentsReplyNotificationsItem) {
            // validation for constraint: itemType
            if (!$getTrackingDocumentsReplyNotificationsItem instanceof \cosolis\StructType\CosolisNotification) {
                $invalidValues[] = is_object($getTrackingDocumentsReplyNotificationsItem) ? get_class($getTrackingDocumentsReplyNotificationsItem) : sprintf('%s(%s)', gettype($getTrackingDocumentsReplyNotificationsItem), var_export($getTrackingDocumentsReplyNotificationsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Notifications property can only contain items of type \cosolis\StructType\CosolisNotification, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Notifications value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisNotification[] $notifications
     * @return \cosolis\StructType\CosolisGetTrackingDocumentsReply
     */
    public function setNotifications(array $notifications = array())
    {
        // validation for constraint: array
        if ('' !== ($notificationsArrayErrorMessage = self::validateNotificationsForArrayConstraintsFromSetNotifications($notifications))) {
            throw new \InvalidArgumentException($notificationsArrayErrorMessage, __LINE__);
        }
        $this->Notifications = $notifications;
        return $this;
    }
    /**
     * Add item to Notifications value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisNotification $item
     * @return \cosolis\StructType\CosolisGetTrackingDocumentsReply
     */
    public function addToNotifications(\cosolis\StructType\CosolisNotification $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cosolis\StructType\CosolisNotification) {
            throw new \InvalidArgumentException(sprintf('The Notifications property can only contain items of type \cosolis\StructType\CosolisNotification, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Notifications[] = $item;
        return $this;
    }
    /**
     * Get Version value
     * @return \cosolis\StructType\CosolisVersionId
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param \cosolis\StructType\CosolisVersionId $version
     * @return \cosolis\StructType\CosolisGetTrackingDocumentsReply
     */
    public function setVersion(\cosolis\StructType\CosolisVersionId $version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get TransactionDetail value
     * @return \cosolis\StructType\CosolisTransactionDetail|null
     */
    public function getTransactionDetail()
    {
        return $this->TransactionDetail;
    }
    /**
     * Set TransactionDetail value
     * @param \cosolis\StructType\CosolisTransactionDetail $transactionDetail
     * @return \cosolis\StructType\CosolisGetTrackingDocumentsReply
     */
    public function setTransactionDetail(\cosolis\StructType\CosolisTransactionDetail $transactionDetail = null)
    {
        $this->TransactionDetail = $transactionDetail;
        return $this;
    }
    /**
     * Get Documents value
     * @return \cosolis\StructType\CosolisTrackingDocument[]|null
     */
    public function getDocuments()
    {
        return $this->Documents;
    }
    /**
     * This method is responsible for validating the values passed to the setDocuments method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocuments method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentsForArrayConstraintsFromSetDocuments(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getTrackingDocumentsReplyDocumentsItem) {
            // validation for constraint: itemType
            if (!$getTrackingDocumentsReplyDocumentsItem instanceof \cosolis\StructType\CosolisTrackingDocument) {
                $invalidValues[] = is_object($getTrackingDocumentsReplyDocumentsItem) ? get_class($getTrackingDocumentsReplyDocumentsItem) : sprintf('%s(%s)', gettype($getTrackingDocumentsReplyDocumentsItem), var_export($getTrackingDocumentsReplyDocumentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Documents property can only contain items of type \cosolis\StructType\CosolisTrackingDocument, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Documents value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisTrackingDocument[] $documents
     * @return \cosolis\StructType\CosolisGetTrackingDocumentsReply
     */
    public function setDocuments(array $documents = array())
    {
        // validation for constraint: array
        if ('' !== ($documentsArrayErrorMessage = self::validateDocumentsForArrayConstraintsFromSetDocuments($documents))) {
            throw new \InvalidArgumentException($documentsArrayErrorMessage, __LINE__);
        }
        $this->Documents = $documents;
        return $this;
    }
    /**
     * Add item to Documents value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisTrackingDocument $item
     * @return \cosolis\StructType\CosolisGetTrackingDocumentsReply
     */
    public function addToDocuments(\cosolis\StructType\CosolisTrackingDocument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cosolis\StructType\CosolisTrackingDocument) {
            throw new \InvalidArgumentException(sprintf('The Documents property can only contain items of type \cosolis\StructType\CosolisTrackingDocument, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Documents[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisGetTrackingDocumentsReply
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
