<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentPart StructType
 * Meta information extracted from the WSDL
 * - documentation: Successive parts of the document (only one, for PDF documents).
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisDocumentPart extends AbstractStructBase
{
    /**
     * The SequenceNumber
     * Meta information extracted from the WSDL
     * - documentation: The one-origin position of this part within a document.
     * - minOccurs: 0
     * @var int
     */
    public $SequenceNumber;
    /**
     * The Content
     * Meta information extracted from the WSDL
     * - documentation: Graphic or printer commands for this image within a document.
     * - minOccurs: 0
     * @var string
     */
    public $Content;
    /**
     * Constructor method for DocumentPart
     * @uses CosolisDocumentPart::setSequenceNumber()
     * @uses CosolisDocumentPart::setContent()
     * @param int $sequenceNumber
     * @param string $content
     */
    public function __construct($sequenceNumber = null, $content = null)
    {
        $this
            ->setSequenceNumber($sequenceNumber)
            ->setContent($content);
    }
    /**
     * Get SequenceNumber value
     * @return int|null
     */
    public function getSequenceNumber()
    {
        return $this->SequenceNumber;
    }
    /**
     * Set SequenceNumber value
     * @param int $sequenceNumber
     * @return \cosolis\StructType\CosolisDocumentPart
     */
    public function setSequenceNumber($sequenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNumber) && !(is_int($sequenceNumber) || ctype_digit($sequenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sequenceNumber, true), gettype($sequenceNumber)), __LINE__);
        }
        $this->SequenceNumber = $sequenceNumber;
        return $this;
    }
    /**
     * Get Content value
     * @return string|null
     */
    public function getContent()
    {
        return $this->Content;
    }
    /**
     * Set Content value
     * @param string $content
     * @return \cosolis\StructType\CosolisDocumentPart
     */
    public function setContent($content = null)
    {
        // validation for constraint: string
        if (!is_null($content) && !is_string($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($content, true), gettype($content)), __LINE__);
        }
        $this->Content = $content;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisDocumentPart
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
