<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Distance StructType
 * Meta information extracted from the WSDL
 * - documentation: Driving or other transportation distances, distinct from dimension measurements.
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisDistance extends AbstractStructBase
{
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - documentation: Identifies the distance quantity.
     * - minOccurs: 0
     * @var float
     */
    public $Value;
    /**
     * The Units
     * Meta information extracted from the WSDL
     * - documentation: Identifies the unit of measure for the distance value.
     * - minOccurs: 0
     * @var string
     */
    public $Units;
    /**
     * Constructor method for Distance
     * @uses CosolisDistance::setValue()
     * @uses CosolisDistance::setUnits()
     * @param float $value
     * @param string $units
     */
    public function __construct($value = null, $units = null)
    {
        $this
            ->setValue($value)
            ->setUnits($units);
    }
    /**
     * Get Value value
     * @return float|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param float $value
     * @return \cosolis\StructType\CosolisDistance
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get Units value
     * @return string|null
     */
    public function getUnits()
    {
        return $this->Units;
    }
    /**
     * Set Units value
     * @uses \cosolis\EnumType\CosolisDistanceUnits::valueIsValid()
     * @uses \cosolis\EnumType\CosolisDistanceUnits::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $units
     * @return \cosolis\StructType\CosolisDistance
     */
    public function setUnits($units = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisDistanceUnits::valueIsValid($units)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisDistanceUnits', is_array($units) ? implode(', ', $units) : var_export($units, true), implode(', ', \cosolis\EnumType\CosolisDistanceUnits::getValidValues())), __LINE__);
        }
        $this->Units = $units;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisDistance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
