<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryOptionEligibilityDetail StructType
 * Meta information extracted from the WSDL
 * - documentation: Details about the eligibility for a delivery option.
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisDeliveryOptionEligibilityDetail extends AbstractStructBase
{
    /**
     * The Option
     * Meta information extracted from the WSDL
     * - documentation: Type of delivery option.
     * - minOccurs: 0
     * @var string
     */
    public $Option;
    /**
     * The Eligibility
     * Meta information extracted from the WSDL
     * - documentation: Eligibility of the customer for the specific delivery option.
     * - minOccurs: 0
     * @var string
     */
    public $Eligibility;
    /**
     * Constructor method for DeliveryOptionEligibilityDetail
     * @uses CosolisDeliveryOptionEligibilityDetail::setOption()
     * @uses CosolisDeliveryOptionEligibilityDetail::setEligibility()
     * @param string $option
     * @param string $eligibility
     */
    public function __construct($option = null, $eligibility = null)
    {
        $this
            ->setOption($option)
            ->setEligibility($eligibility);
    }
    /**
     * Get Option value
     * @return string|null
     */
    public function getOption()
    {
        return $this->Option;
    }
    /**
     * Set Option value
     * @uses \cosolis\EnumType\CosolisDeliveryOptionType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisDeliveryOptionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $option
     * @return \cosolis\StructType\CosolisDeliveryOptionEligibilityDetail
     */
    public function setOption($option = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisDeliveryOptionType::valueIsValid($option)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisDeliveryOptionType', is_array($option) ? implode(', ', $option) : var_export($option, true), implode(', ', \cosolis\EnumType\CosolisDeliveryOptionType::getValidValues())), __LINE__);
        }
        $this->Option = $option;
        return $this;
    }
    /**
     * Get Eligibility value
     * @return string|null
     */
    public function getEligibility()
    {
        return $this->Eligibility;
    }
    /**
     * Set Eligibility value
     * @uses \cosolis\EnumType\CosolisEligibilityType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisEligibilityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $eligibility
     * @return \cosolis\StructType\CosolisDeliveryOptionEligibilityDetail
     */
    public function setEligibility($eligibility = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisEligibilityType::valueIsValid($eligibility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisEligibilityType', is_array($eligibility) ? implode(', ', $eligibility) : var_export($eligibility, true), implode(', ', \cosolis\EnumType\CosolisEligibilityType::getValidValues())), __LINE__);
        }
        $this->Eligibility = $eligibility;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisDeliveryOptionEligibilityDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
