<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerExceptionRequestDetail StructType
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisCustomerExceptionRequestDetail extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - documentation: Unique identifier for the customer exception request.
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * The StatusDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StatusDescription;
    /**
     * The CreateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreateTime;
    /**
     * Constructor method for CustomerExceptionRequestDetail
     * @uses CosolisCustomerExceptionRequestDetail::setId()
     * @uses CosolisCustomerExceptionRequestDetail::setStatusCode()
     * @uses CosolisCustomerExceptionRequestDetail::setStatusDescription()
     * @uses CosolisCustomerExceptionRequestDetail::setCreateTime()
     * @param string $id
     * @param string $statusCode
     * @param string $statusDescription
     * @param string $createTime
     */
    public function __construct($id = null, $statusCode = null, $statusDescription = null, $createTime = null)
    {
        $this
            ->setId($id)
            ->setStatusCode($statusCode)
            ->setStatusDescription($statusDescription)
            ->setCreateTime($createTime);
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \cosolis\StructType\CosolisCustomerExceptionRequestDetail
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \cosolis\StructType\CosolisCustomerExceptionRequestDetail
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get StatusDescription value
     * @return string|null
     */
    public function getStatusDescription()
    {
        return $this->StatusDescription;
    }
    /**
     * Set StatusDescription value
     * @param string $statusDescription
     * @return \cosolis\StructType\CosolisCustomerExceptionRequestDetail
     */
    public function setStatusDescription($statusDescription = null)
    {
        // validation for constraint: string
        if (!is_null($statusDescription) && !is_string($statusDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusDescription, true), gettype($statusDescription)), __LINE__);
        }
        $this->StatusDescription = $statusDescription;
        return $this;
    }
    /**
     * Get CreateTime value
     * @return string|null
     */
    public function getCreateTime()
    {
        return $this->CreateTime;
    }
    /**
     * Set CreateTime value
     * @param string $createTime
     * @return \cosolis\StructType\CosolisCustomerExceptionRequestDetail
     */
    public function setCreateTime($createTime = null)
    {
        // validation for constraint: string
        if (!is_null($createTime) && !is_string($createTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createTime, true), gettype($createTime)), __LINE__);
        }
        $this->CreateTime = $createTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisCustomerExceptionRequestDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
