<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContentRecord StructType
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisContentRecord extends AbstractStructBase
{
    /**
     * The PartNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PartNumber;
    /**
     * The ItemNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ItemNumber;
    /**
     * The ReceivedQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ReceivedQuantity;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for ContentRecord
     * @uses CosolisContentRecord::setPartNumber()
     * @uses CosolisContentRecord::setItemNumber()
     * @uses CosolisContentRecord::setReceivedQuantity()
     * @uses CosolisContentRecord::setDescription()
     * @param string $partNumber
     * @param string $itemNumber
     * @param int $receivedQuantity
     * @param string $description
     */
    public function __construct($partNumber = null, $itemNumber = null, $receivedQuantity = null, $description = null)
    {
        $this
            ->setPartNumber($partNumber)
            ->setItemNumber($itemNumber)
            ->setReceivedQuantity($receivedQuantity)
            ->setDescription($description);
    }
    /**
     * Get PartNumber value
     * @return string|null
     */
    public function getPartNumber()
    {
        return $this->PartNumber;
    }
    /**
     * Set PartNumber value
     * @param string $partNumber
     * @return \cosolis\StructType\CosolisContentRecord
     */
    public function setPartNumber($partNumber = null)
    {
        // validation for constraint: string
        if (!is_null($partNumber) && !is_string($partNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partNumber, true), gettype($partNumber)), __LINE__);
        }
        $this->PartNumber = $partNumber;
        return $this;
    }
    /**
     * Get ItemNumber value
     * @return string|null
     */
    public function getItemNumber()
    {
        return $this->ItemNumber;
    }
    /**
     * Set ItemNumber value
     * @param string $itemNumber
     * @return \cosolis\StructType\CosolisContentRecord
     */
    public function setItemNumber($itemNumber = null)
    {
        // validation for constraint: string
        if (!is_null($itemNumber) && !is_string($itemNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemNumber, true), gettype($itemNumber)), __LINE__);
        }
        $this->ItemNumber = $itemNumber;
        return $this;
    }
    /**
     * Get ReceivedQuantity value
     * @return int|null
     */
    public function getReceivedQuantity()
    {
        return $this->ReceivedQuantity;
    }
    /**
     * Set ReceivedQuantity value
     * @param int $receivedQuantity
     * @return \cosolis\StructType\CosolisContentRecord
     */
    public function setReceivedQuantity($receivedQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($receivedQuantity) && !(is_int($receivedQuantity) || ctype_digit($receivedQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($receivedQuantity, true), gettype($receivedQuantity)), __LINE__);
        }
        $this->ReceivedQuantity = $receivedQuantity;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \cosolis\StructType\CosolisContentRecord
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisContentRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
