<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompletedTrackDetail StructType
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisCompletedTrackDetail extends AbstractStructBase
{
    /**
     * The HighestSeverity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $HighestSeverity;
    /**
     * The Notifications
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisNotification[]
     */
    public $Notifications;
    /**
     * The DuplicateWaybill
     * Meta information extracted from the WSDL
     * - documentation: True if duplicate packages (more than one package with the same tracking number) have been found, and only limited data will be provided for each one.
     * - minOccurs: 0
     * @var bool
     */
    public $DuplicateWaybill;
    /**
     * The MoreData
     * Meta information extracted from the WSDL
     * - documentation: True if additional packages remain to be retrieved.
     * - minOccurs: 0
     * @var bool
     */
    public $MoreData;
    /**
     * The PagingToken
     * Meta information extracted from the WSDL
     * - documentation: Value that must be passed in a TrackNotification request to retrieve the next set of packages (when MoreDataAvailable = true).
     * - minOccurs: 0
     * @var string
     */
    public $PagingToken;
    /**
     * The TrackDetailsCount
     * Meta information extracted from the WSDL
     * - documentation: Identifies the total number of available track details across all pages.
     * - minOccurs: 0
     * @var int
     */
    public $TrackDetailsCount;
    /**
     * The TrackDetails
     * Meta information extracted from the WSDL
     * - documentation: Contains detailed tracking information for the requested packages(s).
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisTrackDetail[]
     */
    public $TrackDetails;
    /**
     * Constructor method for CompletedTrackDetail
     * @uses CosolisCompletedTrackDetail::setHighestSeverity()
     * @uses CosolisCompletedTrackDetail::setNotifications()
     * @uses CosolisCompletedTrackDetail::setDuplicateWaybill()
     * @uses CosolisCompletedTrackDetail::setMoreData()
     * @uses CosolisCompletedTrackDetail::setPagingToken()
     * @uses CosolisCompletedTrackDetail::setTrackDetailsCount()
     * @uses CosolisCompletedTrackDetail::setTrackDetails()
     * @param string $highestSeverity
     * @param \cosolis\StructType\CosolisNotification[] $notifications
     * @param bool $duplicateWaybill
     * @param bool $moreData
     * @param string $pagingToken
     * @param int $trackDetailsCount
     * @param \cosolis\StructType\CosolisTrackDetail[] $trackDetails
     */
    public function __construct($highestSeverity = null, array $notifications = array(), $duplicateWaybill = null, $moreData = null, $pagingToken = null, $trackDetailsCount = null, array $trackDetails = array())
    {
        $this
            ->setHighestSeverity($highestSeverity)
            ->setNotifications($notifications)
            ->setDuplicateWaybill($duplicateWaybill)
            ->setMoreData($moreData)
            ->setPagingToken($pagingToken)
            ->setTrackDetailsCount($trackDetailsCount)
            ->setTrackDetails($trackDetails);
    }
    /**
     * Get HighestSeverity value
     * @return string|null
     */
    public function getHighestSeverity()
    {
        return $this->HighestSeverity;
    }
    /**
     * Set HighestSeverity value
     * @uses \cosolis\EnumType\CosolisNotificationSeverityType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisNotificationSeverityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $highestSeverity
     * @return \cosolis\StructType\CosolisCompletedTrackDetail
     */
    public function setHighestSeverity($highestSeverity = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisNotificationSeverityType::valueIsValid($highestSeverity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisNotificationSeverityType', is_array($highestSeverity) ? implode(', ', $highestSeverity) : var_export($highestSeverity, true), implode(', ', \cosolis\EnumType\CosolisNotificationSeverityType::getValidValues())), __LINE__);
        }
        $this->HighestSeverity = $highestSeverity;
        return $this;
    }
    /**
     * Get Notifications value
     * @return \cosolis\StructType\CosolisNotification[]|null
     */
    public function getNotifications()
    {
        return $this->Notifications;
    }
    /**
     * This method is responsible for validating the values passed to the setNotifications method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNotifications method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNotificationsForArrayConstraintsFromSetNotifications(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $completedTrackDetailNotificationsItem) {
            // validation for constraint: itemType
            if (!$completedTrackDetailNotificationsItem instanceof \cosolis\StructType\CosolisNotification) {
                $invalidValues[] = is_object($completedTrackDetailNotificationsItem) ? get_class($completedTrackDetailNotificationsItem) : sprintf('%s(%s)', gettype($completedTrackDetailNotificationsItem), var_export($completedTrackDetailNotificationsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Notifications property can only contain items of type \cosolis\StructType\CosolisNotification, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Notifications value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisNotification[] $notifications
     * @return \cosolis\StructType\CosolisCompletedTrackDetail
     */
    public function setNotifications(array $notifications = array())
    {
        // validation for constraint: array
        if ('' !== ($notificationsArrayErrorMessage = self::validateNotificationsForArrayConstraintsFromSetNotifications($notifications))) {
            throw new \InvalidArgumentException($notificationsArrayErrorMessage, __LINE__);
        }
        $this->Notifications = $notifications;
        return $this;
    }
    /**
     * Add item to Notifications value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisNotification $item
     * @return \cosolis\StructType\CosolisCompletedTrackDetail
     */
    public function addToNotifications(\cosolis\StructType\CosolisNotification $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cosolis\StructType\CosolisNotification) {
            throw new \InvalidArgumentException(sprintf('The Notifications property can only contain items of type \cosolis\StructType\CosolisNotification, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Notifications[] = $item;
        return $this;
    }
    /**
     * Get DuplicateWaybill value
     * @return bool|null
     */
    public function getDuplicateWaybill()
    {
        return $this->DuplicateWaybill;
    }
    /**
     * Set DuplicateWaybill value
     * @param bool $duplicateWaybill
     * @return \cosolis\StructType\CosolisCompletedTrackDetail
     */
    public function setDuplicateWaybill($duplicateWaybill = null)
    {
        // validation for constraint: boolean
        if (!is_null($duplicateWaybill) && !is_bool($duplicateWaybill)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($duplicateWaybill, true), gettype($duplicateWaybill)), __LINE__);
        }
        $this->DuplicateWaybill = $duplicateWaybill;
        return $this;
    }
    /**
     * Get MoreData value
     * @return bool|null
     */
    public function getMoreData()
    {
        return $this->MoreData;
    }
    /**
     * Set MoreData value
     * @param bool $moreData
     * @return \cosolis\StructType\CosolisCompletedTrackDetail
     */
    public function setMoreData($moreData = null)
    {
        // validation for constraint: boolean
        if (!is_null($moreData) && !is_bool($moreData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($moreData, true), gettype($moreData)), __LINE__);
        }
        $this->MoreData = $moreData;
        return $this;
    }
    /**
     * Get PagingToken value
     * @return string|null
     */
    public function getPagingToken()
    {
        return $this->PagingToken;
    }
    /**
     * Set PagingToken value
     * @param string $pagingToken
     * @return \cosolis\StructType\CosolisCompletedTrackDetail
     */
    public function setPagingToken($pagingToken = null)
    {
        // validation for constraint: string
        if (!is_null($pagingToken) && !is_string($pagingToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pagingToken, true), gettype($pagingToken)), __LINE__);
        }
        $this->PagingToken = $pagingToken;
        return $this;
    }
    /**
     * Get TrackDetailsCount value
     * @return int|null
     */
    public function getTrackDetailsCount()
    {
        return $this->TrackDetailsCount;
    }
    /**
     * Set TrackDetailsCount value
     * @param int $trackDetailsCount
     * @return \cosolis\StructType\CosolisCompletedTrackDetail
     */
    public function setTrackDetailsCount($trackDetailsCount = null)
    {
        // validation for constraint: int
        if (!is_null($trackDetailsCount) && !(is_int($trackDetailsCount) || ctype_digit($trackDetailsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($trackDetailsCount, true), gettype($trackDetailsCount)), __LINE__);
        }
        $this->TrackDetailsCount = $trackDetailsCount;
        return $this;
    }
    /**
     * Get TrackDetails value
     * @return \cosolis\StructType\CosolisTrackDetail[]|null
     */
    public function getTrackDetails()
    {
        return $this->TrackDetails;
    }
    /**
     * This method is responsible for validating the values passed to the setTrackDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTrackDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTrackDetailsForArrayConstraintsFromSetTrackDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $completedTrackDetailTrackDetailsItem) {
            // validation for constraint: itemType
            if (!$completedTrackDetailTrackDetailsItem instanceof \cosolis\StructType\CosolisTrackDetail) {
                $invalidValues[] = is_object($completedTrackDetailTrackDetailsItem) ? get_class($completedTrackDetailTrackDetailsItem) : sprintf('%s(%s)', gettype($completedTrackDetailTrackDetailsItem), var_export($completedTrackDetailTrackDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TrackDetails property can only contain items of type \cosolis\StructType\CosolisTrackDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TrackDetails value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisTrackDetail[] $trackDetails
     * @return \cosolis\StructType\CosolisCompletedTrackDetail
     */
    public function setTrackDetails(array $trackDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($trackDetailsArrayErrorMessage = self::validateTrackDetailsForArrayConstraintsFromSetTrackDetails($trackDetails))) {
            throw new \InvalidArgumentException($trackDetailsArrayErrorMessage, __LINE__);
        }
        $this->TrackDetails = $trackDetails;
        return $this;
    }
    /**
     * Add item to TrackDetails value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisTrackDetail $item
     * @return \cosolis\StructType\CosolisCompletedTrackDetail
     */
    public function addToTrackDetails(\cosolis\StructType\CosolisTrackDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cosolis\StructType\CosolisTrackDetail) {
            throw new \InvalidArgumentException(sprintf('The TrackDetails property can only contain items of type \cosolis\StructType\CosolisTrackDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TrackDetails[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisCompletedTrackDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
