<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Commodity StructType
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisCommodity extends AbstractStructBase
{
    /**
     * The CommodityId
     * Meta information extracted from the WSDL
     * - documentation: Value used to identify a commodity description; must be unique within the containing shipment.
     * - minOccurs: 0
     * @var string
     */
    public $CommodityId;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: FedEx internal commodity identifier
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The NumberOfPieces
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumberOfPieces;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: A free-form description of the commodity, which could be used for customs clearance documentation.
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Purpose
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Purpose;
    /**
     * The CountryOfManufacture
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CountryOfManufacture;
    /**
     * The HarmonizedCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $HarmonizedCode;
    /**
     * The Weight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisWeight
     */
    public $Weight;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Quantity;
    /**
     * The QuantityUnits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $QuantityUnits;
    /**
     * The AdditionalMeasures
     * Meta information extracted from the WSDL
     * - documentation: Contains only additional quantitative information other than weight and quantity to calculate duties and taxes.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisMeasure[]
     */
    public $AdditionalMeasures;
    /**
     * The UnitPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisMoney
     */
    public $UnitPrice;
    /**
     * The CustomsValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisMoney
     */
    public $CustomsValue;
    /**
     * The ExciseConditions
     * Meta information extracted from the WSDL
     * - documentation: Defines additional characteristic of commodity used to calculate duties and taxes
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisEdtExciseCondition[]
     */
    public $ExciseConditions;
    /**
     * The ExportLicenseNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExportLicenseNumber;
    /**
     * The ExportLicenseExpirationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExportLicenseExpirationDate;
    /**
     * The CIMarksAndNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CIMarksAndNumbers;
    /**
     * The PartNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PartNumber;
    /**
     * The NaftaDetail
     * Meta information extracted from the WSDL
     * - documentation: All data required for this commodity in NAFTA Certificate of Origin.
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisNaftaCommodityDetail
     */
    public $NaftaDetail;
    /**
     * Constructor method for Commodity
     * @uses CosolisCommodity::setCommodityId()
     * @uses CosolisCommodity::setName()
     * @uses CosolisCommodity::setNumberOfPieces()
     * @uses CosolisCommodity::setDescription()
     * @uses CosolisCommodity::setPurpose()
     * @uses CosolisCommodity::setCountryOfManufacture()
     * @uses CosolisCommodity::setHarmonizedCode()
     * @uses CosolisCommodity::setWeight()
     * @uses CosolisCommodity::setQuantity()
     * @uses CosolisCommodity::setQuantityUnits()
     * @uses CosolisCommodity::setAdditionalMeasures()
     * @uses CosolisCommodity::setUnitPrice()
     * @uses CosolisCommodity::setCustomsValue()
     * @uses CosolisCommodity::setExciseConditions()
     * @uses CosolisCommodity::setExportLicenseNumber()
     * @uses CosolisCommodity::setExportLicenseExpirationDate()
     * @uses CosolisCommodity::setCIMarksAndNumbers()
     * @uses CosolisCommodity::setPartNumber()
     * @uses CosolisCommodity::setNaftaDetail()
     * @param string $commodityId
     * @param string $name
     * @param int $numberOfPieces
     * @param string $description
     * @param string $purpose
     * @param string $countryOfManufacture
     * @param string $harmonizedCode
     * @param \cosolis\StructType\CosolisWeight $weight
     * @param float $quantity
     * @param string $quantityUnits
     * @param \cosolis\StructType\CosolisMeasure[] $additionalMeasures
     * @param \cosolis\StructType\CosolisMoney $unitPrice
     * @param \cosolis\StructType\CosolisMoney $customsValue
     * @param \cosolis\StructType\CosolisEdtExciseCondition[] $exciseConditions
     * @param string $exportLicenseNumber
     * @param string $exportLicenseExpirationDate
     * @param string $cIMarksAndNumbers
     * @param string $partNumber
     * @param \cosolis\StructType\CosolisNaftaCommodityDetail $naftaDetail
     */
    public function __construct($commodityId = null, $name = null, $numberOfPieces = null, $description = null, $purpose = null, $countryOfManufacture = null, $harmonizedCode = null, \cosolis\StructType\CosolisWeight $weight = null, $quantity = null, $quantityUnits = null, array $additionalMeasures = array(), \cosolis\StructType\CosolisMoney $unitPrice = null, \cosolis\StructType\CosolisMoney $customsValue = null, array $exciseConditions = array(), $exportLicenseNumber = null, $exportLicenseExpirationDate = null, $cIMarksAndNumbers = null, $partNumber = null, \cosolis\StructType\CosolisNaftaCommodityDetail $naftaDetail = null)
    {
        $this
            ->setCommodityId($commodityId)
            ->setName($name)
            ->setNumberOfPieces($numberOfPieces)
            ->setDescription($description)
            ->setPurpose($purpose)
            ->setCountryOfManufacture($countryOfManufacture)
            ->setHarmonizedCode($harmonizedCode)
            ->setWeight($weight)
            ->setQuantity($quantity)
            ->setQuantityUnits($quantityUnits)
            ->setAdditionalMeasures($additionalMeasures)
            ->setUnitPrice($unitPrice)
            ->setCustomsValue($customsValue)
            ->setExciseConditions($exciseConditions)
            ->setExportLicenseNumber($exportLicenseNumber)
            ->setExportLicenseExpirationDate($exportLicenseExpirationDate)
            ->setCIMarksAndNumbers($cIMarksAndNumbers)
            ->setPartNumber($partNumber)
            ->setNaftaDetail($naftaDetail);
    }
    /**
     * Get CommodityId value
     * @return string|null
     */
    public function getCommodityId()
    {
        return $this->CommodityId;
    }
    /**
     * Set CommodityId value
     * @param string $commodityId
     * @return \cosolis\StructType\CosolisCommodity
     */
    public function setCommodityId($commodityId = null)
    {
        // validation for constraint: string
        if (!is_null($commodityId) && !is_string($commodityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commodityId, true), gettype($commodityId)), __LINE__);
        }
        $this->CommodityId = $commodityId;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \cosolis\StructType\CosolisCommodity
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get NumberOfPieces value
     * @return int|null
     */
    public function getNumberOfPieces()
    {
        return $this->NumberOfPieces;
    }
    /**
     * Set NumberOfPieces value
     * @param int $numberOfPieces
     * @return \cosolis\StructType\CosolisCommodity
     */
    public function setNumberOfPieces($numberOfPieces = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfPieces) && !(is_int($numberOfPieces) || ctype_digit($numberOfPieces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfPieces, true), gettype($numberOfPieces)), __LINE__);
        }
        $this->NumberOfPieces = $numberOfPieces;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \cosolis\StructType\CosolisCommodity
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Purpose value
     * @return string|null
     */
    public function getPurpose()
    {
        return $this->Purpose;
    }
    /**
     * Set Purpose value
     * @uses \cosolis\EnumType\CosolisCommodityPurposeType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisCommodityPurposeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $purpose
     * @return \cosolis\StructType\CosolisCommodity
     */
    public function setPurpose($purpose = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisCommodityPurposeType::valueIsValid($purpose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisCommodityPurposeType', is_array($purpose) ? implode(', ', $purpose) : var_export($purpose, true), implode(', ', \cosolis\EnumType\CosolisCommodityPurposeType::getValidValues())), __LINE__);
        }
        $this->Purpose = $purpose;
        return $this;
    }
    /**
     * Get CountryOfManufacture value
     * @return string|null
     */
    public function getCountryOfManufacture()
    {
        return $this->CountryOfManufacture;
    }
    /**
     * Set CountryOfManufacture value
     * @param string $countryOfManufacture
     * @return \cosolis\StructType\CosolisCommodity
     */
    public function setCountryOfManufacture($countryOfManufacture = null)
    {
        // validation for constraint: string
        if (!is_null($countryOfManufacture) && !is_string($countryOfManufacture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryOfManufacture, true), gettype($countryOfManufacture)), __LINE__);
        }
        $this->CountryOfManufacture = $countryOfManufacture;
        return $this;
    }
    /**
     * Get HarmonizedCode value
     * @return string|null
     */
    public function getHarmonizedCode()
    {
        return $this->HarmonizedCode;
    }
    /**
     * Set HarmonizedCode value
     * @param string $harmonizedCode
     * @return \cosolis\StructType\CosolisCommodity
     */
    public function setHarmonizedCode($harmonizedCode = null)
    {
        // validation for constraint: string
        if (!is_null($harmonizedCode) && !is_string($harmonizedCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($harmonizedCode, true), gettype($harmonizedCode)), __LINE__);
        }
        $this->HarmonizedCode = $harmonizedCode;
        return $this;
    }
    /**
     * Get Weight value
     * @return \cosolis\StructType\CosolisWeight|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param \cosolis\StructType\CosolisWeight $weight
     * @return \cosolis\StructType\CosolisCommodity
     */
    public function setWeight(\cosolis\StructType\CosolisWeight $weight = null)
    {
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \cosolis\StructType\CosolisCommodity
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get QuantityUnits value
     * @return string|null
     */
    public function getQuantityUnits()
    {
        return $this->QuantityUnits;
    }
    /**
     * Set QuantityUnits value
     * @param string $quantityUnits
     * @return \cosolis\StructType\CosolisCommodity
     */
    public function setQuantityUnits($quantityUnits = null)
    {
        // validation for constraint: string
        if (!is_null($quantityUnits) && !is_string($quantityUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quantityUnits, true), gettype($quantityUnits)), __LINE__);
        }
        $this->QuantityUnits = $quantityUnits;
        return $this;
    }
    /**
     * Get AdditionalMeasures value
     * @return \cosolis\StructType\CosolisMeasure[]|null
     */
    public function getAdditionalMeasures()
    {
        return $this->AdditionalMeasures;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalMeasures method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalMeasures method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalMeasuresForArrayConstraintsFromSetAdditionalMeasures(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commodityAdditionalMeasuresItem) {
            // validation for constraint: itemType
            if (!$commodityAdditionalMeasuresItem instanceof \cosolis\StructType\CosolisMeasure) {
                $invalidValues[] = is_object($commodityAdditionalMeasuresItem) ? get_class($commodityAdditionalMeasuresItem) : sprintf('%s(%s)', gettype($commodityAdditionalMeasuresItem), var_export($commodityAdditionalMeasuresItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdditionalMeasures property can only contain items of type \cosolis\StructType\CosolisMeasure, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdditionalMeasures value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisMeasure[] $additionalMeasures
     * @return \cosolis\StructType\CosolisCommodity
     */
    public function setAdditionalMeasures(array $additionalMeasures = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalMeasuresArrayErrorMessage = self::validateAdditionalMeasuresForArrayConstraintsFromSetAdditionalMeasures($additionalMeasures))) {
            throw new \InvalidArgumentException($additionalMeasuresArrayErrorMessage, __LINE__);
        }
        $this->AdditionalMeasures = $additionalMeasures;
        return $this;
    }
    /**
     * Add item to AdditionalMeasures value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisMeasure $item
     * @return \cosolis\StructType\CosolisCommodity
     */
    public function addToAdditionalMeasures(\cosolis\StructType\CosolisMeasure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cosolis\StructType\CosolisMeasure) {
            throw new \InvalidArgumentException(sprintf('The AdditionalMeasures property can only contain items of type \cosolis\StructType\CosolisMeasure, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AdditionalMeasures[] = $item;
        return $this;
    }
    /**
     * Get UnitPrice value
     * @return \cosolis\StructType\CosolisMoney|null
     */
    public function getUnitPrice()
    {
        return $this->UnitPrice;
    }
    /**
     * Set UnitPrice value
     * @param \cosolis\StructType\CosolisMoney $unitPrice
     * @return \cosolis\StructType\CosolisCommodity
     */
    public function setUnitPrice(\cosolis\StructType\CosolisMoney $unitPrice = null)
    {
        $this->UnitPrice = $unitPrice;
        return $this;
    }
    /**
     * Get CustomsValue value
     * @return \cosolis\StructType\CosolisMoney|null
     */
    public function getCustomsValue()
    {
        return $this->CustomsValue;
    }
    /**
     * Set CustomsValue value
     * @param \cosolis\StructType\CosolisMoney $customsValue
     * @return \cosolis\StructType\CosolisCommodity
     */
    public function setCustomsValue(\cosolis\StructType\CosolisMoney $customsValue = null)
    {
        $this->CustomsValue = $customsValue;
        return $this;
    }
    /**
     * Get ExciseConditions value
     * @return \cosolis\StructType\CosolisEdtExciseCondition[]|null
     */
    public function getExciseConditions()
    {
        return $this->ExciseConditions;
    }
    /**
     * This method is responsible for validating the values passed to the setExciseConditions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExciseConditions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExciseConditionsForArrayConstraintsFromSetExciseConditions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commodityExciseConditionsItem) {
            // validation for constraint: itemType
            if (!$commodityExciseConditionsItem instanceof \cosolis\StructType\CosolisEdtExciseCondition) {
                $invalidValues[] = is_object($commodityExciseConditionsItem) ? get_class($commodityExciseConditionsItem) : sprintf('%s(%s)', gettype($commodityExciseConditionsItem), var_export($commodityExciseConditionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ExciseConditions property can only contain items of type \cosolis\StructType\CosolisEdtExciseCondition, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ExciseConditions value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisEdtExciseCondition[] $exciseConditions
     * @return \cosolis\StructType\CosolisCommodity
     */
    public function setExciseConditions(array $exciseConditions = array())
    {
        // validation for constraint: array
        if ('' !== ($exciseConditionsArrayErrorMessage = self::validateExciseConditionsForArrayConstraintsFromSetExciseConditions($exciseConditions))) {
            throw new \InvalidArgumentException($exciseConditionsArrayErrorMessage, __LINE__);
        }
        $this->ExciseConditions = $exciseConditions;
        return $this;
    }
    /**
     * Add item to ExciseConditions value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisEdtExciseCondition $item
     * @return \cosolis\StructType\CosolisCommodity
     */
    public function addToExciseConditions(\cosolis\StructType\CosolisEdtExciseCondition $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cosolis\StructType\CosolisEdtExciseCondition) {
            throw new \InvalidArgumentException(sprintf('The ExciseConditions property can only contain items of type \cosolis\StructType\CosolisEdtExciseCondition, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ExciseConditions[] = $item;
        return $this;
    }
    /**
     * Get ExportLicenseNumber value
     * @return string|null
     */
    public function getExportLicenseNumber()
    {
        return $this->ExportLicenseNumber;
    }
    /**
     * Set ExportLicenseNumber value
     * @param string $exportLicenseNumber
     * @return \cosolis\StructType\CosolisCommodity
     */
    public function setExportLicenseNumber($exportLicenseNumber = null)
    {
        // validation for constraint: string
        if (!is_null($exportLicenseNumber) && !is_string($exportLicenseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exportLicenseNumber, true), gettype($exportLicenseNumber)), __LINE__);
        }
        $this->ExportLicenseNumber = $exportLicenseNumber;
        return $this;
    }
    /**
     * Get ExportLicenseExpirationDate value
     * @return string|null
     */
    public function getExportLicenseExpirationDate()
    {
        return $this->ExportLicenseExpirationDate;
    }
    /**
     * Set ExportLicenseExpirationDate value
     * @param string $exportLicenseExpirationDate
     * @return \cosolis\StructType\CosolisCommodity
     */
    public function setExportLicenseExpirationDate($exportLicenseExpirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($exportLicenseExpirationDate) && !is_string($exportLicenseExpirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exportLicenseExpirationDate, true), gettype($exportLicenseExpirationDate)), __LINE__);
        }
        $this->ExportLicenseExpirationDate = $exportLicenseExpirationDate;
        return $this;
    }
    /**
     * Get CIMarksAndNumbers value
     * @return string|null
     */
    public function getCIMarksAndNumbers()
    {
        return $this->CIMarksAndNumbers;
    }
    /**
     * Set CIMarksAndNumbers value
     * @param string $cIMarksAndNumbers
     * @return \cosolis\StructType\CosolisCommodity
     */
    public function setCIMarksAndNumbers($cIMarksAndNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($cIMarksAndNumbers) && !is_string($cIMarksAndNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cIMarksAndNumbers, true), gettype($cIMarksAndNumbers)), __LINE__);
        }
        $this->CIMarksAndNumbers = $cIMarksAndNumbers;
        return $this;
    }
    /**
     * Get PartNumber value
     * @return string|null
     */
    public function getPartNumber()
    {
        return $this->PartNumber;
    }
    /**
     * Set PartNumber value
     * @param string $partNumber
     * @return \cosolis\StructType\CosolisCommodity
     */
    public function setPartNumber($partNumber = null)
    {
        // validation for constraint: string
        if (!is_null($partNumber) && !is_string($partNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partNumber, true), gettype($partNumber)), __LINE__);
        }
        $this->PartNumber = $partNumber;
        return $this;
    }
    /**
     * Get NaftaDetail value
     * @return \cosolis\StructType\CosolisNaftaCommodityDetail|null
     */
    public function getNaftaDetail()
    {
        return $this->NaftaDetail;
    }
    /**
     * Set NaftaDetail value
     * @param \cosolis\StructType\CosolisNaftaCommodityDetail $naftaDetail
     * @return \cosolis\StructType\CosolisCommodity
     */
    public function setNaftaDetail(\cosolis\StructType\CosolisNaftaCommodityDetail $naftaDetail = null)
    {
        $this->NaftaDetail = $naftaDetail;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisCommodity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
