<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AppointmentTimeDetail StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies the details about the appointment time window.
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisAppointmentTimeDetail extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: The description that FedEx Ground uses for the appointment window being specified.
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The Window
     * Meta information extracted from the WSDL
     * - documentation: Specifies the window of time for an appointment.
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisLocalTimeRange
     */
    public $Window;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for AppointmentTimeDetail
     * @uses CosolisAppointmentTimeDetail::setType()
     * @uses CosolisAppointmentTimeDetail::setWindow()
     * @uses CosolisAppointmentTimeDetail::setDescription()
     * @param string $type
     * @param \cosolis\StructType\CosolisLocalTimeRange $window
     * @param string $description
     */
    public function __construct($type = null, \cosolis\StructType\CosolisLocalTimeRange $window = null, $description = null)
    {
        $this
            ->setType($type)
            ->setWindow($window)
            ->setDescription($description);
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \cosolis\EnumType\CosolisAppointmentWindowType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisAppointmentWindowType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \cosolis\StructType\CosolisAppointmentTimeDetail
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisAppointmentWindowType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisAppointmentWindowType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \cosolis\EnumType\CosolisAppointmentWindowType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Window value
     * @return \cosolis\StructType\CosolisLocalTimeRange|null
     */
    public function getWindow()
    {
        return $this->Window;
    }
    /**
     * Set Window value
     * @param \cosolis\StructType\CosolisLocalTimeRange $window
     * @return \cosolis\StructType\CosolisAppointmentTimeDetail
     */
    public function setWindow(\cosolis\StructType\CosolisLocalTimeRange $window = null)
    {
        $this->Window = $window;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \cosolis\StructType\CosolisAppointmentTimeDetail
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisAppointmentTimeDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
