<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AppointmentDetail StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies the different appointment times on a specific date.
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisAppointmentDetail extends AbstractStructBase
{
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Date;
    /**
     * The WindowDetails
     * Meta information extracted from the WSDL
     * - documentation: Different appointment time windows on the date specified.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisAppointmentTimeDetail[]
     */
    public $WindowDetails;
    /**
     * Constructor method for AppointmentDetail
     * @uses CosolisAppointmentDetail::setDate()
     * @uses CosolisAppointmentDetail::setWindowDetails()
     * @param string $date
     * @param \cosolis\StructType\CosolisAppointmentTimeDetail[] $windowDetails
     */
    public function __construct($date = null, array $windowDetails = array())
    {
        $this
            ->setDate($date)
            ->setWindowDetails($windowDetails);
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \cosolis\StructType\CosolisAppointmentDetail
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get WindowDetails value
     * @return \cosolis\StructType\CosolisAppointmentTimeDetail[]|null
     */
    public function getWindowDetails()
    {
        return $this->WindowDetails;
    }
    /**
     * This method is responsible for validating the values passed to the setWindowDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWindowDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWindowDetailsForArrayConstraintsFromSetWindowDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $appointmentDetailWindowDetailsItem) {
            // validation for constraint: itemType
            if (!$appointmentDetailWindowDetailsItem instanceof \cosolis\StructType\CosolisAppointmentTimeDetail) {
                $invalidValues[] = is_object($appointmentDetailWindowDetailsItem) ? get_class($appointmentDetailWindowDetailsItem) : sprintf('%s(%s)', gettype($appointmentDetailWindowDetailsItem), var_export($appointmentDetailWindowDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WindowDetails property can only contain items of type \cosolis\StructType\CosolisAppointmentTimeDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WindowDetails value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisAppointmentTimeDetail[] $windowDetails
     * @return \cosolis\StructType\CosolisAppointmentDetail
     */
    public function setWindowDetails(array $windowDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($windowDetailsArrayErrorMessage = self::validateWindowDetailsForArrayConstraintsFromSetWindowDetails($windowDetails))) {
            throw new \InvalidArgumentException($windowDetailsArrayErrorMessage, __LINE__);
        }
        $this->WindowDetails = $windowDetails;
        return $this;
    }
    /**
     * Add item to WindowDetails value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisAppointmentTimeDetail $item
     * @return \cosolis\StructType\CosolisAppointmentDetail
     */
    public function addToWindowDetails(\cosolis\StructType\CosolisAppointmentTimeDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cosolis\StructType\CosolisAppointmentTimeDetail) {
            throw new \InvalidArgumentException(sprintf('The WindowDetails property can only contain items of type \cosolis\StructType\CosolisAppointmentTimeDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WindowDetails[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisAppointmentDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
