<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Address StructType
 * Meta information extracted from the WSDL
 * - documentation: Descriptive data for a physical location. May be used as an actual physical address (place to which one could go), or as a container of "address parts" which should be handled as a unit (such as a city-state-ZIP combination within
 * the US).
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisAddress extends AbstractStructBase
{
    /**
     * The StreetLines
     * Meta information extracted from the WSDL
     * - documentation: Combination of number, street name, etc. At least one line is required for a valid physical address; empty lines should not be included.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $StreetLines;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - documentation: Name of city, town, etc.
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The StateOrProvinceCode
     * Meta information extracted from the WSDL
     * - documentation: Identifying abbreviation for US state, Canada province, etc. Format and presence of this field will vary, depending on country.
     * - minOccurs: 0
     * @var string
     */
    public $StateOrProvinceCode;
    /**
     * The PostalCode
     * Meta information extracted from the WSDL
     * - documentation: Identification of a region (usually small) for mail/package delivery. Format and presence of this field will vary, depending on country.
     * - minOccurs: 0
     * @var string
     */
    public $PostalCode;
    /**
     * The UrbanizationCode
     * Meta information extracted from the WSDL
     * - documentation: Relevant only to addresses in Puerto Rico.
     * - minOccurs: 0
     * @var string
     */
    public $UrbanizationCode;
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - documentation: The two-letter code used to identify a country.
     * - minOccurs: 0
     * @var string
     */
    public $CountryCode;
    /**
     * The CountryName
     * Meta information extracted from the WSDL
     * - documentation: The fully spelt out name of a country.
     * - minOccurs: 0
     * @var string
     */
    public $CountryName;
    /**
     * The Residential
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether this address residential (as opposed to commercial).
     * - minOccurs: 0
     * @var bool
     */
    public $Residential;
    /**
     * The GeographicCoordinates
     * Meta information extracted from the WSDL
     * - documentation: The geographic coordinates cooresponding to this address.
     * - minOccurs: 0
     * @var string
     */
    public $GeographicCoordinates;
    /**
     * Constructor method for Address
     * @uses CosolisAddress::setStreetLines()
     * @uses CosolisAddress::setCity()
     * @uses CosolisAddress::setStateOrProvinceCode()
     * @uses CosolisAddress::setPostalCode()
     * @uses CosolisAddress::setUrbanizationCode()
     * @uses CosolisAddress::setCountryCode()
     * @uses CosolisAddress::setCountryName()
     * @uses CosolisAddress::setResidential()
     * @uses CosolisAddress::setGeographicCoordinates()
     * @param string[] $streetLines
     * @param string $city
     * @param string $stateOrProvinceCode
     * @param string $postalCode
     * @param string $urbanizationCode
     * @param string $countryCode
     * @param string $countryName
     * @param bool $residential
     * @param string $geographicCoordinates
     */
    public function __construct(array $streetLines = array(), $city = null, $stateOrProvinceCode = null, $postalCode = null, $urbanizationCode = null, $countryCode = null, $countryName = null, $residential = null, $geographicCoordinates = null)
    {
        $this
            ->setStreetLines($streetLines)
            ->setCity($city)
            ->setStateOrProvinceCode($stateOrProvinceCode)
            ->setPostalCode($postalCode)
            ->setUrbanizationCode($urbanizationCode)
            ->setCountryCode($countryCode)
            ->setCountryName($countryName)
            ->setResidential($residential)
            ->setGeographicCoordinates($geographicCoordinates);
    }
    /**
     * Get StreetLines value
     * @return string[]|null
     */
    public function getStreetLines()
    {
        return $this->StreetLines;
    }
    /**
     * This method is responsible for validating the values passed to the setStreetLines method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStreetLines method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStreetLinesForArrayConstraintsFromSetStreetLines(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $addressStreetLinesItem) {
            // validation for constraint: itemType
            if (!is_string($addressStreetLinesItem)) {
                $invalidValues[] = is_object($addressStreetLinesItem) ? get_class($addressStreetLinesItem) : sprintf('%s(%s)', gettype($addressStreetLinesItem), var_export($addressStreetLinesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The StreetLines property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set StreetLines value
     * @throws \InvalidArgumentException
     * @param string[] $streetLines
     * @return \cosolis\StructType\CosolisAddress
     */
    public function setStreetLines(array $streetLines = array())
    {
        // validation for constraint: array
        if ('' !== ($streetLinesArrayErrorMessage = self::validateStreetLinesForArrayConstraintsFromSetStreetLines($streetLines))) {
            throw new \InvalidArgumentException($streetLinesArrayErrorMessage, __LINE__);
        }
        $this->StreetLines = $streetLines;
        return $this;
    }
    /**
     * Add item to StreetLines value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \cosolis\StructType\CosolisAddress
     */
    public function addToStreetLines($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The StreetLines property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->StreetLines[] = $item;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \cosolis\StructType\CosolisAddress
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get StateOrProvinceCode value
     * @return string|null
     */
    public function getStateOrProvinceCode()
    {
        return $this->StateOrProvinceCode;
    }
    /**
     * Set StateOrProvinceCode value
     * @param string $stateOrProvinceCode
     * @return \cosolis\StructType\CosolisAddress
     */
    public function setStateOrProvinceCode($stateOrProvinceCode = null)
    {
        // validation for constraint: string
        if (!is_null($stateOrProvinceCode) && !is_string($stateOrProvinceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateOrProvinceCode, true), gettype($stateOrProvinceCode)), __LINE__);
        }
        $this->StateOrProvinceCode = $stateOrProvinceCode;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \cosolis\StructType\CosolisAddress
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get UrbanizationCode value
     * @return string|null
     */
    public function getUrbanizationCode()
    {
        return $this->UrbanizationCode;
    }
    /**
     * Set UrbanizationCode value
     * @param string $urbanizationCode
     * @return \cosolis\StructType\CosolisAddress
     */
    public function setUrbanizationCode($urbanizationCode = null)
    {
        // validation for constraint: string
        if (!is_null($urbanizationCode) && !is_string($urbanizationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urbanizationCode, true), gettype($urbanizationCode)), __LINE__);
        }
        $this->UrbanizationCode = $urbanizationCode;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \cosolis\StructType\CosolisAddress
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get CountryName value
     * @return string|null
     */
    public function getCountryName()
    {
        return $this->CountryName;
    }
    /**
     * Set CountryName value
     * @param string $countryName
     * @return \cosolis\StructType\CosolisAddress
     */
    public function setCountryName($countryName = null)
    {
        // validation for constraint: string
        if (!is_null($countryName) && !is_string($countryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryName, true), gettype($countryName)), __LINE__);
        }
        $this->CountryName = $countryName;
        return $this;
    }
    /**
     * Get Residential value
     * @return bool|null
     */
    public function getResidential()
    {
        return $this->Residential;
    }
    /**
     * Set Residential value
     * @param bool $residential
     * @return \cosolis\StructType\CosolisAddress
     */
    public function setResidential($residential = null)
    {
        // validation for constraint: boolean
        if (!is_null($residential) && !is_bool($residential)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($residential, true), gettype($residential)), __LINE__);
        }
        $this->Residential = $residential;
        return $this;
    }
    /**
     * Get GeographicCoordinates value
     * @return string|null
     */
    public function getGeographicCoordinates()
    {
        return $this->GeographicCoordinates;
    }
    /**
     * Set GeographicCoordinates value
     * @param string $geographicCoordinates
     * @return \cosolis\StructType\CosolisAddress
     */
    public function setGeographicCoordinates($geographicCoordinates = null)
    {
        // validation for constraint: string
        if (!is_null($geographicCoordinates) && !is_string($geographicCoordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geographicCoordinates, true), gettype($geographicCoordinates)), __LINE__);
        }
        $this->GeographicCoordinates = $geographicCoordinates;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisAddress
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
