<?php

namespace cosolis\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Track ServiceType
 * @package Cosolis
 * @subpackage Services
 */
class CosolisTrack extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named track
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \cosolis\StructType\CosolisTrackRequest $trackRequest
     * @return \cosolis\StructType\CosolisTrackReply|bool
     */
    public function track(\cosolis\StructType\CosolisTrackRequest $trackRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->track($trackRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \cosolis\StructType\CosolisTrackReply
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
