<?php

namespace cosolis\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Send ServiceType
 * @package Cosolis
 * @subpackage Services
 */
class CosolisSend extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named sendNotifications
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \cosolis\StructType\CosolisSendNotificationsRequest $sendNotificationsRequest
     * @return \cosolis\StructType\CosolisSendNotificationsReply|bool
     */
    public function sendNotifications(\cosolis\StructType\CosolisSendNotificationsRequest $sendNotificationsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->sendNotifications($sendNotificationsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \cosolis\StructType\CosolisSendNotificationsReply
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
