<?php

namespace cosolis\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @package Cosolis
 * @subpackage Services
 */
class CosolisGet extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getTrackingDocuments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \cosolis\StructType\CosolisGetTrackingDocumentsRequest $getTrackingDocumentsRequest
     * @return \cosolis\StructType\CosolisGetTrackingDocumentsReply|bool
     */
    public function getTrackingDocuments(\cosolis\StructType\CosolisGetTrackingDocumentsRequest $getTrackingDocumentsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->getTrackingDocuments($getTrackingDocumentsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \cosolis\StructType\CosolisGetTrackingDocumentsReply
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
