<?php

namespace cosolis;

/**
 * Class which returns the class map definition
 * @package Cosolis
 */
class CosolisClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'Address' => '\\cosolis\\StructType\\CosolisAddress',
            'AppointmentDetail' => '\\cosolis\\StructType\\CosolisAppointmentDetail',
            'AppointmentTimeDetail' => '\\cosolis\\StructType\\CosolisAppointmentTimeDetail',
            'AvailableImagesDetail' => '\\cosolis\\StructType\\CosolisAvailableImagesDetail',
            'ClientDetail' => '\\cosolis\\StructType\\CosolisClientDetail',
            'Commodity' => '\\cosolis\\StructType\\CosolisCommodity',
            'CompletedTrackDetail' => '\\cosolis\\StructType\\CosolisCompletedTrackDetail',
            'Contact' => '\\cosolis\\StructType\\CosolisContact',
            'ContactAndAddress' => '\\cosolis\\StructType\\CosolisContactAndAddress',
            'ContentRecord' => '\\cosolis\\StructType\\CosolisContentRecord',
            'CustomerExceptionRequestDetail' => '\\cosolis\\StructType\\CosolisCustomerExceptionRequestDetail',
            'CustomsOptionDetail' => '\\cosolis\\StructType\\CosolisCustomsOptionDetail',
            'DateRange' => '\\cosolis\\StructType\\CosolisDateRange',
            'DeliveryOptionEligibilityDetail' => '\\cosolis\\StructType\\CosolisDeliveryOptionEligibilityDetail',
            'Dimensions' => '\\cosolis\\StructType\\CosolisDimensions',
            'Distance' => '\\cosolis\\StructType\\CosolisDistance',
            'DocumentPart' => '\\cosolis\\StructType\\CosolisDocumentPart',
            'EMailDetail' => '\\cosolis\\StructType\\CosolisEMailDetail',
            'EdtExciseCondition' => '\\cosolis\\StructType\\CosolisEdtExciseCondition',
            'FaxDetail' => '\\cosolis\\StructType\\CosolisFaxDetail',
            'GetTrackingDocumentsReply' => '\\cosolis\\StructType\\CosolisGetTrackingDocumentsReply',
            'GetTrackingDocumentsRequest' => '\\cosolis\\StructType\\CosolisGetTrackingDocumentsRequest',
            'LocalTimeRange' => '\\cosolis\\StructType\\CosolisLocalTimeRange',
            'Localization' => '\\cosolis\\StructType\\CosolisLocalization',
            'Measure' => '\\cosolis\\StructType\\CosolisMeasure',
            'Money' => '\\cosolis\\StructType\\CosolisMoney',
            'NaftaCommodityDetail' => '\\cosolis\\StructType\\CosolisNaftaCommodityDetail',
            'Notification' => '\\cosolis\\StructType\\CosolisNotification',
            'NotificationDetail' => '\\cosolis\\StructType\\CosolisNotificationDetail',
            'NotificationParameter' => '\\cosolis\\StructType\\CosolisNotificationParameter',
            'PagingDetail' => '\\cosolis\\StructType\\CosolisPagingDetail',
            'PieceCountVerificationDetail' => '\\cosolis\\StructType\\CosolisPieceCountVerificationDetail',
            'SendNotificationsReply' => '\\cosolis\\StructType\\CosolisSendNotificationsReply',
            'SendNotificationsRequest' => '\\cosolis\\StructType\\CosolisSendNotificationsRequest',
            'ShipmentEventNotificationDetail' => '\\cosolis\\StructType\\CosolisShipmentEventNotificationDetail',
            'ShipmentEventNotificationSpecification' => '\\cosolis\\StructType\\CosolisShipmentEventNotificationSpecification',
            'ShipmentNotificationFormatSpecification' => '\\cosolis\\StructType\\CosolisShipmentNotificationFormatSpecification',
            'SignatureImageDetail' => '\\cosolis\\StructType\\CosolisSignatureImageDetail',
            'SpecialInstructionStatusDetail' => '\\cosolis\\StructType\\CosolisSpecialInstructionStatusDetail',
            'StringBarcode' => '\\cosolis\\StructType\\CosolisStringBarcode',
            'TrackAdvanceNotificationDetail' => '\\cosolis\\StructType\\CosolisTrackAdvanceNotificationDetail',
            'TrackChargeDetail' => '\\cosolis\\StructType\\CosolisTrackChargeDetail',
            'TrackDetail' => '\\cosolis\\StructType\\CosolisTrackDetail',
            'TrackEvent' => '\\cosolis\\StructType\\CosolisTrackEvent',
            'TrackInformationNoteDetail' => '\\cosolis\\StructType\\CosolisTrackInformationNoteDetail',
            'TrackNotificationPackage' => '\\cosolis\\StructType\\CosolisTrackNotificationPackage',
            'TrackNotificationRecipientDetail' => '\\cosolis\\StructType\\CosolisTrackNotificationRecipientDetail',
            'TrackOtherIdentifierDetail' => '\\cosolis\\StructType\\CosolisTrackOtherIdentifierDetail',
            'TrackPackageIdentifier' => '\\cosolis\\StructType\\CosolisTrackPackageIdentifier',
            'TrackPackagingDescriptionDetail' => '\\cosolis\\StructType\\CosolisTrackPackagingDescriptionDetail',
            'TrackPayment' => '\\cosolis\\StructType\\CosolisTrackPayment',
            'TrackReconciliation' => '\\cosolis\\StructType\\CosolisTrackReconciliation',
            'TrackReply' => '\\cosolis\\StructType\\CosolisTrackReply',
            'TrackRequest' => '\\cosolis\\StructType\\CosolisTrackRequest',
            'TrackReturnDetail' => '\\cosolis\\StructType\\CosolisTrackReturnDetail',
            'TrackSelectionDetail' => '\\cosolis\\StructType\\CosolisTrackSelectionDetail',
            'TrackServiceDescriptionDetail' => '\\cosolis\\StructType\\CosolisTrackServiceDescriptionDetail',
            'TrackSpecialHandling' => '\\cosolis\\StructType\\CosolisTrackSpecialHandling',
            'TrackSpecialInstruction' => '\\cosolis\\StructType\\CosolisTrackSpecialInstruction',
            'TrackSplitShipmentPart' => '\\cosolis\\StructType\\CosolisTrackSplitShipmentPart',
            'TrackStatusAncillaryDetail' => '\\cosolis\\StructType\\CosolisTrackStatusAncillaryDetail',
            'TrackStatusDetail' => '\\cosolis\\StructType\\CosolisTrackStatusDetail',
            'TrackingBillOfLadingDocumentDetail' => '\\cosolis\\StructType\\CosolisTrackingBillOfLadingDocumentDetail',
            'TrackingDateOrTimestamp' => '\\cosolis\\StructType\\CosolisTrackingDateOrTimestamp',
            'TrackingDocument' => '\\cosolis\\StructType\\CosolisTrackingDocument',
            'TrackingDocumentDispositionDetail' => '\\cosolis\\StructType\\CosolisTrackingDocumentDispositionDetail',
            'TrackingDocumentEmailDetail' => '\\cosolis\\StructType\\CosolisTrackingDocumentEmailDetail',
            'TrackingDocumentFormat' => '\\cosolis\\StructType\\CosolisTrackingDocumentFormat',
            'TrackingDocumentSpecification' => '\\cosolis\\StructType\\CosolisTrackingDocumentSpecification',
            'TrackingFreightBillingDocumentDetail' => '\\cosolis\\StructType\\CosolisTrackingFreightBillingDocumentDetail',
            'TrackingSignatureProofOfDeliveryDetail' => '\\cosolis\\StructType\\CosolisTrackingSignatureProofOfDeliveryDetail',
            'TransactionDetail' => '\\cosolis\\StructType\\CosolisTransactionDetail',
            'Weight' => '\\cosolis\\StructType\\CosolisWeight',
            'WebAuthenticationDetail' => '\\cosolis\\StructType\\CosolisWebAuthenticationDetail',
            'WebAuthenticationCredential' => '\\cosolis\\StructType\\CosolisWebAuthenticationCredential',
            'VersionId' => '\\cosolis\\StructType\\CosolisVersionId',
        );
    }
}
