<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Sync ServiceType
 */
$sync = new \ServiceType\Sync($options);
/**
 * Sample call for syncSubscriptionData operation/method
 */
if ($sync->syncSubscriptionData(new \StructType\SyncSubscriptionData()) !== false) {
    print_r($sync->getResult());
} else {
    print_r($sync->getLastError());
}
/**
 * Sample call for syncOrderRelation operation/method
 */
if ($sync->syncOrderRelation(new \StructType\SyncOrderRelation()) !== false) {
    print_r($sync->getResult());
} else {
    print_r($sync->getLastError());
}
/**
 * Sample call for syncMSISDNChange operation/method
 */
if ($sync->syncMSISDNChange(new \StructType\SyncMSISDNChange()) !== false) {
    print_r($sync->getResult());
} else {
    print_r($sync->getLastError());
}
/**
 * Sample call for syncSubscriptionActive operation/method
 */
if ($sync->syncSubscriptionActive(new \StructType\SyncSubscriptionActive()) !== false) {
    print_r($sync->getResult());
} else {
    print_r($sync->getLastError());
}
/**
 * Samples for Change ServiceType
 */
$change = new \ServiceType\Change($options);
/**
 * Sample call for changeMSISDN operation/method
 */
if ($change->changeMSISDN(new \StructType\ChangeMSISDN()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
