<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for changeMSISDN StructType
 * Meta information extracted from the WSDL
 * - type: sag_data_sync_local_xsd:changeMSISDN
 * @subpackage Structs
 */
class ChangeMSISDN extends AbstractStructBase
{
    /**
     * The MSISDN
     * @var string
     */
    public $MSISDN;
    /**
     * The newMSISDN
     * @var string
     */
    public $newMSISDN;
    /**
     * The timeStamp
     * @var string
     */
    public $timeStamp;
    /**
     * Constructor method for changeMSISDN
     * @uses ChangeMSISDN::setMSISDN()
     * @uses ChangeMSISDN::setNewMSISDN()
     * @uses ChangeMSISDN::setTimeStamp()
     * @param string $mSISDN
     * @param string $newMSISDN
     * @param string $timeStamp
     */
    public function __construct($mSISDN = null, $newMSISDN = null, $timeStamp = null)
    {
        $this
            ->setMSISDN($mSISDN)
            ->setNewMSISDN($newMSISDN)
            ->setTimeStamp($timeStamp);
    }
    /**
     * Get MSISDN value
     * @return string|null
     */
    public function getMSISDN()
    {
        return $this->MSISDN;
    }
    /**
     * Set MSISDN value
     * @param string $mSISDN
     * @return \StructType\ChangeMSISDN
     */
    public function setMSISDN($mSISDN = null)
    {
        // validation for constraint: string
        if (!is_null($mSISDN) && !is_string($mSISDN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mSISDN, true), gettype($mSISDN)), __LINE__);
        }
        $this->MSISDN = $mSISDN;
        return $this;
    }
    /**
     * Get newMSISDN value
     * @return string|null
     */
    public function getNewMSISDN()
    {
        return $this->newMSISDN;
    }
    /**
     * Set newMSISDN value
     * @param string $newMSISDN
     * @return \StructType\ChangeMSISDN
     */
    public function setNewMSISDN($newMSISDN = null)
    {
        // validation for constraint: string
        if (!is_null($newMSISDN) && !is_string($newMSISDN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newMSISDN, true), gettype($newMSISDN)), __LINE__);
        }
        $this->newMSISDN = $newMSISDN;
        return $this;
    }
    /**
     * Get timeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->timeStamp;
    }
    /**
     * Set timeStamp value
     * @param string $timeStamp
     * @return \StructType\ChangeMSISDN
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeStamp, true), gettype($timeStamp)), __LINE__);
        }
        $this->timeStamp = $timeStamp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ChangeMSISDN
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
