<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for syncSubscriptionData StructType
 * Meta information extracted from the WSDL
 * - type: sag_data_sync_local_xsd:syncSubscriptionData
 * @subpackage Structs
 */
class SyncSubscriptionData extends AbstractStructBase
{
    /**
     * The MSISDN
     * @var string
     */
    public $MSISDN;
    /**
     * The serviceId
     * @var string
     */
    public $serviceId;
    /**
     * The productId
     * @var string
     */
    public $productId;
    /**
     * The updateType
     * @var int
     */
    public $updateType;
    /**
     * The productDetail
     * @var mixed
     */
    public $productDetail;
    /**
     * Constructor method for syncSubscriptionData
     * @uses SyncSubscriptionData::setMSISDN()
     * @uses SyncSubscriptionData::setServiceId()
     * @uses SyncSubscriptionData::setProductId()
     * @uses SyncSubscriptionData::setUpdateType()
     * @uses SyncSubscriptionData::setProductDetail()
     * @param string $mSISDN
     * @param string $serviceId
     * @param string $productId
     * @param int $updateType
     * @param mixed $productDetail
     */
    public function __construct($mSISDN = null, $serviceId = null, $productId = null, $updateType = null, $productDetail = null)
    {
        $this
            ->setMSISDN($mSISDN)
            ->setServiceId($serviceId)
            ->setProductId($productId)
            ->setUpdateType($updateType)
            ->setProductDetail($productDetail);
    }
    /**
     * Get MSISDN value
     * @return string|null
     */
    public function getMSISDN()
    {
        return $this->MSISDN;
    }
    /**
     * Set MSISDN value
     * @param string $mSISDN
     * @return \StructType\SyncSubscriptionData
     */
    public function setMSISDN($mSISDN = null)
    {
        // validation for constraint: string
        if (!is_null($mSISDN) && !is_string($mSISDN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mSISDN, true), gettype($mSISDN)), __LINE__);
        }
        $this->MSISDN = $mSISDN;
        return $this;
    }
    /**
     * Get serviceId value
     * @return string|null
     */
    public function getServiceId()
    {
        return $this->serviceId;
    }
    /**
     * Set serviceId value
     * @param string $serviceId
     * @return \StructType\SyncSubscriptionData
     */
    public function setServiceId($serviceId = null)
    {
        // validation for constraint: string
        if (!is_null($serviceId) && !is_string($serviceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceId, true), gettype($serviceId)), __LINE__);
        }
        $this->serviceId = $serviceId;
        return $this;
    }
    /**
     * Get productId value
     * @return string|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param string $productId
     * @return \StructType\SyncSubscriptionData
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get updateType value
     * @return int|null
     */
    public function getUpdateType()
    {
        return $this->updateType;
    }
    /**
     * Set updateType value
     * @param int $updateType
     * @return \StructType\SyncSubscriptionData
     */
    public function setUpdateType($updateType = null)
    {
        // validation for constraint: int
        if (!is_null($updateType) && !(is_int($updateType) || ctype_digit($updateType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($updateType, true), gettype($updateType)), __LINE__);
        }
        $this->updateType = $updateType;
        return $this;
    }
    /**
     * Get productDetail value
     * @return mixed|null
     */
    public function getProductDetail()
    {
        return $this->productDetail;
    }
    /**
     * Set productDetail value
     * @param mixed $productDetail
     * @return \StructType\SyncSubscriptionData
     */
    public function setProductDetail($productDetail = null)
    {
        $this->productDetail = $productDetail;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SyncSubscriptionData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
