<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for syncSubscriptionActiveResponse StructType
 * Meta information extracted from the WSDL
 * - type: sag_data_sync_local_xsd:syncSubscriptionActiveResponse
 * @subpackage Structs
 */
class SyncSubscriptionActiveResponse extends AbstractStructBase
{
    /**
     * The result
     * @var int
     */
    public $result;
    /**
     * The resultDescription
     * @var string
     */
    public $resultDescription;
    /**
     * The extensionInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var mixed
     */
    public $extensionInfo;
    /**
     * Constructor method for syncSubscriptionActiveResponse
     * @uses SyncSubscriptionActiveResponse::setResult()
     * @uses SyncSubscriptionActiveResponse::setResultDescription()
     * @uses SyncSubscriptionActiveResponse::setExtensionInfo()
     * @param int $result
     * @param string $resultDescription
     * @param mixed $extensionInfo
     */
    public function __construct($result = null, $resultDescription = null, $extensionInfo = null)
    {
        $this
            ->setResult($result)
            ->setResultDescription($resultDescription)
            ->setExtensionInfo($extensionInfo);
    }
    /**
     * Get result value
     * @return int|null
     */
    public function getResult()
    {
        return $this->result;
    }
    /**
     * Set result value
     * @param int $result
     * @return \StructType\SyncSubscriptionActiveResponse
     */
    public function setResult($result = null)
    {
        // validation for constraint: int
        if (!is_null($result) && !(is_int($result) || ctype_digit($result))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($result, true), gettype($result)), __LINE__);
        }
        $this->result = $result;
        return $this;
    }
    /**
     * Get resultDescription value
     * @return string|null
     */
    public function getResultDescription()
    {
        return $this->resultDescription;
    }
    /**
     * Set resultDescription value
     * @param string $resultDescription
     * @return \StructType\SyncSubscriptionActiveResponse
     */
    public function setResultDescription($resultDescription = null)
    {
        // validation for constraint: string
        if (!is_null($resultDescription) && !is_string($resultDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultDescription, true), gettype($resultDescription)), __LINE__);
        }
        $this->resultDescription = $resultDescription;
        return $this;
    }
    /**
     * Get extensionInfo value
     * @return mixed|null
     */
    public function getExtensionInfo()
    {
        return $this->extensionInfo;
    }
    /**
     * Set extensionInfo value
     * @param mixed $extensionInfo
     * @return \StructType\SyncSubscriptionActiveResponse
     */
    public function setExtensionInfo($extensionInfo = null)
    {
        $this->extensionInfo = $extensionInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SyncSubscriptionActiveResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
