<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductDetail StructType
 * @subpackage Structs
 */
class ProductDetail extends AbstractStructBase
{
    /**
     * The notifySPURL
     * @var string
     */
    public $notifySPURL;
    /**
     * The operationTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $operationTime;
    /**
     * The subscriptionValidTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $subscriptionValidTime;
    /**
     * The subscriptionAddtionalInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $subscriptionAddtionalInfo;
    /**
     * Constructor method for ProductDetail
     * @uses ProductDetail::setNotifySPURL()
     * @uses ProductDetail::setOperationTime()
     * @uses ProductDetail::setSubscriptionValidTime()
     * @uses ProductDetail::setSubscriptionAddtionalInfo()
     * @param string $notifySPURL
     * @param string $operationTime
     * @param string $subscriptionValidTime
     * @param string $subscriptionAddtionalInfo
     */
    public function __construct($notifySPURL = null, $operationTime = null, $subscriptionValidTime = null, $subscriptionAddtionalInfo = null)
    {
        $this
            ->setNotifySPURL($notifySPURL)
            ->setOperationTime($operationTime)
            ->setSubscriptionValidTime($subscriptionValidTime)
            ->setSubscriptionAddtionalInfo($subscriptionAddtionalInfo);
    }
    /**
     * Get notifySPURL value
     * @return string|null
     */
    public function getNotifySPURL()
    {
        return $this->notifySPURL;
    }
    /**
     * Set notifySPURL value
     * @param string $notifySPURL
     * @return \StructType\ProductDetail
     */
    public function setNotifySPURL($notifySPURL = null)
    {
        // validation for constraint: string
        if (!is_null($notifySPURL) && !is_string($notifySPURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notifySPURL, true), gettype($notifySPURL)), __LINE__);
        }
        $this->notifySPURL = $notifySPURL;
        return $this;
    }
    /**
     * Get operationTime value
     * @return string|null
     */
    public function getOperationTime()
    {
        return $this->operationTime;
    }
    /**
     * Set operationTime value
     * @param string $operationTime
     * @return \StructType\ProductDetail
     */
    public function setOperationTime($operationTime = null)
    {
        // validation for constraint: string
        if (!is_null($operationTime) && !is_string($operationTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationTime, true), gettype($operationTime)), __LINE__);
        }
        $this->operationTime = $operationTime;
        return $this;
    }
    /**
     * Get subscriptionValidTime value
     * @return string|null
     */
    public function getSubscriptionValidTime()
    {
        return $this->subscriptionValidTime;
    }
    /**
     * Set subscriptionValidTime value
     * @param string $subscriptionValidTime
     * @return \StructType\ProductDetail
     */
    public function setSubscriptionValidTime($subscriptionValidTime = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionValidTime) && !is_string($subscriptionValidTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionValidTime, true), gettype($subscriptionValidTime)), __LINE__);
        }
        $this->subscriptionValidTime = $subscriptionValidTime;
        return $this;
    }
    /**
     * Get subscriptionAddtionalInfo value
     * @return string|null
     */
    public function getSubscriptionAddtionalInfo()
    {
        return $this->subscriptionAddtionalInfo;
    }
    /**
     * Set subscriptionAddtionalInfo value
     * @param string $subscriptionAddtionalInfo
     * @return \StructType\ProductDetail
     */
    public function setSubscriptionAddtionalInfo($subscriptionAddtionalInfo = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionAddtionalInfo) && !is_string($subscriptionAddtionalInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionAddtionalInfo, true), gettype($subscriptionAddtionalInfo)), __LINE__);
        }
        $this->subscriptionAddtionalInfo = $subscriptionAddtionalInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
