<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Sync ServiceType
 * @subpackage Services
 */
class Sync extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named syncSubscriptionData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SyncSubscriptionData $syncSubscriptionData
     * @return \StructType\SyncSubscriptionDataResponse|bool
     */
    public function syncSubscriptionData(\StructType\SyncSubscriptionData $syncSubscriptionData)
    {
        try {
            $this->setResult($this->getSoapClient()->syncSubscriptionData($syncSubscriptionData));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named syncOrderRelation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SyncOrderRelation $syncOrderRelation
     * @return \StructType\SyncOrderRelationResponse|bool
     */
    public function syncOrderRelation(\StructType\SyncOrderRelation $syncOrderRelation)
    {
        try {
            $this->setResult($this->getSoapClient()->syncOrderRelation($syncOrderRelation));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named syncMSISDNChange
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SyncMSISDNChange $syncMSISDNChange
     * @return \StructType\SyncMSISDNChangeResponse|bool
     */
    public function syncMSISDNChange(\StructType\SyncMSISDNChange $syncMSISDNChange)
    {
        try {
            $this->setResult($this->getSoapClient()->syncMSISDNChange($syncMSISDNChange));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named syncSubscriptionActive
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SyncSubscriptionActive $syncSubscriptionActive
     * @return \StructType\SyncSubscriptionActiveResponse|bool
     */
    public function syncSubscriptionActive(\StructType\SyncSubscriptionActive $syncSubscriptionActive)
    {
        try {
            $this->setResult($this->getSoapClient()->syncSubscriptionActive($syncSubscriptionActive));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SyncMSISDNChangeResponse|\StructType\SyncOrderRelationResponse|\StructType\SyncSubscriptionActiveResponse|\StructType\SyncSubscriptionDataResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
