<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Rechnungsinformationen StructType
 * @subpackage Structs
 */
class Rechnungsinformationen extends AbstractStructBase
{
    /**
     * The Rechnung_drucken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Rechnung_drucken;
    /**
     * The Gesamtbetrag_steuer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Gesamtbetrag_steuer;
    /**
     * The Rechnungsnummer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Rechnungsnummer;
    /**
     * The Zahungsart
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Zahungsart;
    /**
     * The Gesamtbetrag_brutto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Gesamtbetrag_brutto;
    /**
     * The Gesamtbetrag_netto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Gesamtbetrag_netto;
    /**
     * The Zahlungshinweise
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Zahlungshinweise;
    /**
     * The Iban
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Iban;
    /**
     * The Bic
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Bic;
    /**
     * The Bankname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Bankname;
    /**
     * The Verwendungszweck
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Verwendungszweck;
    /**
     * The Zahlungsziel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Zahlungsziel;
    /**
     * Constructor method for Rechnungsinformationen
     * @uses Rechnungsinformationen::setRechnung_drucken()
     * @uses Rechnungsinformationen::setGesamtbetrag_steuer()
     * @uses Rechnungsinformationen::setRechnungsnummer()
     * @uses Rechnungsinformationen::setZahungsart()
     * @uses Rechnungsinformationen::setGesamtbetrag_brutto()
     * @uses Rechnungsinformationen::setGesamtbetrag_netto()
     * @uses Rechnungsinformationen::setZahlungshinweise()
     * @uses Rechnungsinformationen::setIban()
     * @uses Rechnungsinformationen::setBic()
     * @uses Rechnungsinformationen::setBankname()
     * @uses Rechnungsinformationen::setVerwendungszweck()
     * @uses Rechnungsinformationen::setZahlungsziel()
     * @param bool $rechnung_drucken
     * @param float $gesamtbetrag_steuer
     * @param string $rechnungsnummer
     * @param string $zahungsart
     * @param string $gesamtbetrag_brutto
     * @param string $gesamtbetrag_netto
     * @param string $zahlungshinweise
     * @param string $iban
     * @param string $bic
     * @param string $bankname
     * @param string $verwendungszweck
     * @param string $zahlungsziel
     */
    public function __construct($rechnung_drucken = null, $gesamtbetrag_steuer = null, $rechnungsnummer = null, $zahungsart = null, $gesamtbetrag_brutto = null, $gesamtbetrag_netto = null, $zahlungshinweise = null, $iban = null, $bic = null, $bankname = null, $verwendungszweck = null, $zahlungsziel = null)
    {
        $this
            ->setRechnung_drucken($rechnung_drucken)
            ->setGesamtbetrag_steuer($gesamtbetrag_steuer)
            ->setRechnungsnummer($rechnungsnummer)
            ->setZahungsart($zahungsart)
            ->setGesamtbetrag_brutto($gesamtbetrag_brutto)
            ->setGesamtbetrag_netto($gesamtbetrag_netto)
            ->setZahlungshinweise($zahlungshinweise)
            ->setIban($iban)
            ->setBic($bic)
            ->setBankname($bankname)
            ->setVerwendungszweck($verwendungszweck)
            ->setZahlungsziel($zahlungsziel);
    }
    /**
     * Get Rechnung_drucken value
     * @return bool
     */
    public function getRechnung_drucken()
    {
        return $this->Rechnung_drucken;
    }
    /**
     * Set Rechnung_drucken value
     * @param bool $rechnung_drucken
     * @return \StructType\Rechnungsinformationen
     */
    public function setRechnung_drucken($rechnung_drucken = null)
    {
        // validation for constraint: boolean
        if (!is_null($rechnung_drucken) && !is_bool($rechnung_drucken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($rechnung_drucken, true), gettype($rechnung_drucken)), __LINE__);
        }
        $this->Rechnung_drucken = $rechnung_drucken;
        return $this;
    }
    /**
     * Get Gesamtbetrag_steuer value
     * @return float
     */
    public function getGesamtbetrag_steuer()
    {
        return $this->Gesamtbetrag_steuer;
    }
    /**
     * Set Gesamtbetrag_steuer value
     * @param float $gesamtbetrag_steuer
     * @return \StructType\Rechnungsinformationen
     */
    public function setGesamtbetrag_steuer($gesamtbetrag_steuer = null)
    {
        // validation for constraint: float
        if (!is_null($gesamtbetrag_steuer) && !(is_float($gesamtbetrag_steuer) || is_numeric($gesamtbetrag_steuer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gesamtbetrag_steuer, true), gettype($gesamtbetrag_steuer)), __LINE__);
        }
        $this->Gesamtbetrag_steuer = $gesamtbetrag_steuer;
        return $this;
    }
    /**
     * Get Rechnungsnummer value
     * @return string|null
     */
    public function getRechnungsnummer()
    {
        return $this->Rechnungsnummer;
    }
    /**
     * Set Rechnungsnummer value
     * @param string $rechnungsnummer
     * @return \StructType\Rechnungsinformationen
     */
    public function setRechnungsnummer($rechnungsnummer = null)
    {
        // validation for constraint: string
        if (!is_null($rechnungsnummer) && !is_string($rechnungsnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rechnungsnummer, true), gettype($rechnungsnummer)), __LINE__);
        }
        $this->Rechnungsnummer = $rechnungsnummer;
        return $this;
    }
    /**
     * Get Zahungsart value
     * @return string|null
     */
    public function getZahungsart()
    {
        return $this->Zahungsart;
    }
    /**
     * Set Zahungsart value
     * @param string $zahungsart
     * @return \StructType\Rechnungsinformationen
     */
    public function setZahungsart($zahungsart = null)
    {
        // validation for constraint: string
        if (!is_null($zahungsart) && !is_string($zahungsart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zahungsart, true), gettype($zahungsart)), __LINE__);
        }
        $this->Zahungsart = $zahungsart;
        return $this;
    }
    /**
     * Get Gesamtbetrag_brutto value
     * @return string|null
     */
    public function getGesamtbetrag_brutto()
    {
        return $this->Gesamtbetrag_brutto;
    }
    /**
     * Set Gesamtbetrag_brutto value
     * @param string $gesamtbetrag_brutto
     * @return \StructType\Rechnungsinformationen
     */
    public function setGesamtbetrag_brutto($gesamtbetrag_brutto = null)
    {
        // validation for constraint: string
        if (!is_null($gesamtbetrag_brutto) && !is_string($gesamtbetrag_brutto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gesamtbetrag_brutto, true), gettype($gesamtbetrag_brutto)), __LINE__);
        }
        $this->Gesamtbetrag_brutto = $gesamtbetrag_brutto;
        return $this;
    }
    /**
     * Get Gesamtbetrag_netto value
     * @return string|null
     */
    public function getGesamtbetrag_netto()
    {
        return $this->Gesamtbetrag_netto;
    }
    /**
     * Set Gesamtbetrag_netto value
     * @param string $gesamtbetrag_netto
     * @return \StructType\Rechnungsinformationen
     */
    public function setGesamtbetrag_netto($gesamtbetrag_netto = null)
    {
        // validation for constraint: string
        if (!is_null($gesamtbetrag_netto) && !is_string($gesamtbetrag_netto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gesamtbetrag_netto, true), gettype($gesamtbetrag_netto)), __LINE__);
        }
        $this->Gesamtbetrag_netto = $gesamtbetrag_netto;
        return $this;
    }
    /**
     * Get Zahlungshinweise value
     * @return string|null
     */
    public function getZahlungshinweise()
    {
        return $this->Zahlungshinweise;
    }
    /**
     * Set Zahlungshinweise value
     * @param string $zahlungshinweise
     * @return \StructType\Rechnungsinformationen
     */
    public function setZahlungshinweise($zahlungshinweise = null)
    {
        // validation for constraint: string
        if (!is_null($zahlungshinweise) && !is_string($zahlungshinweise)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zahlungshinweise, true), gettype($zahlungshinweise)), __LINE__);
        }
        $this->Zahlungshinweise = $zahlungshinweise;
        return $this;
    }
    /**
     * Get Iban value
     * @return string|null
     */
    public function getIban()
    {
        return $this->Iban;
    }
    /**
     * Set Iban value
     * @param string $iban
     * @return \StructType\Rechnungsinformationen
     */
    public function setIban($iban = null)
    {
        // validation for constraint: string
        if (!is_null($iban) && !is_string($iban)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iban, true), gettype($iban)), __LINE__);
        }
        $this->Iban = $iban;
        return $this;
    }
    /**
     * Get Bic value
     * @return string|null
     */
    public function getBic()
    {
        return $this->Bic;
    }
    /**
     * Set Bic value
     * @param string $bic
     * @return \StructType\Rechnungsinformationen
     */
    public function setBic($bic = null)
    {
        // validation for constraint: string
        if (!is_null($bic) && !is_string($bic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bic, true), gettype($bic)), __LINE__);
        }
        $this->Bic = $bic;
        return $this;
    }
    /**
     * Get Bankname value
     * @return string|null
     */
    public function getBankname()
    {
        return $this->Bankname;
    }
    /**
     * Set Bankname value
     * @param string $bankname
     * @return \StructType\Rechnungsinformationen
     */
    public function setBankname($bankname = null)
    {
        // validation for constraint: string
        if (!is_null($bankname) && !is_string($bankname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankname, true), gettype($bankname)), __LINE__);
        }
        $this->Bankname = $bankname;
        return $this;
    }
    /**
     * Get Verwendungszweck value
     * @return string|null
     */
    public function getVerwendungszweck()
    {
        return $this->Verwendungszweck;
    }
    /**
     * Set Verwendungszweck value
     * @param string $verwendungszweck
     * @return \StructType\Rechnungsinformationen
     */
    public function setVerwendungszweck($verwendungszweck = null)
    {
        // validation for constraint: string
        if (!is_null($verwendungszweck) && !is_string($verwendungszweck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($verwendungszweck, true), gettype($verwendungszweck)), __LINE__);
        }
        $this->Verwendungszweck = $verwendungszweck;
        return $this;
    }
    /**
     * Get Zahlungsziel value
     * @return string|null
     */
    public function getZahlungsziel()
    {
        return $this->Zahlungsziel;
    }
    /**
     * Set Zahlungsziel value
     * @param string $zahlungsziel
     * @return \StructType\Rechnungsinformationen
     */
    public function setZahlungsziel($zahlungsziel = null)
    {
        // validation for constraint: string
        if (!is_null($zahlungsziel) && !is_string($zahlungsziel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zahlungsziel, true), gettype($zahlungsziel)), __LINE__);
        }
        $this->Zahlungsziel = $zahlungsziel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Rechnungsinformationen
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
