<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Artikelstamm StructType
 * @subpackage Structs
 */
class Artikelstamm extends AbstractStructBase
{
    /**
     * The mandant
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mandant;
    /**
     * The sachnummer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sachnummer;
    /**
     * The sachbezeichnung
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sachbezeichnung;
    /**
     * The mengeneinheit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mengeneinheit;
    /**
     * Constructor method for Artikelstamm
     * @uses Artikelstamm::setMandant()
     * @uses Artikelstamm::setSachnummer()
     * @uses Artikelstamm::setSachbezeichnung()
     * @uses Artikelstamm::setMengeneinheit()
     * @param string $mandant
     * @param string $sachnummer
     * @param string $sachbezeichnung
     * @param string $mengeneinheit
     */
    public function __construct($mandant = null, $sachnummer = null, $sachbezeichnung = null, $mengeneinheit = null)
    {
        $this
            ->setMandant($mandant)
            ->setSachnummer($sachnummer)
            ->setSachbezeichnung($sachbezeichnung)
            ->setMengeneinheit($mengeneinheit);
    }
    /**
     * Get mandant value
     * @return string|null
     */
    public function getMandant()
    {
        return $this->mandant;
    }
    /**
     * Set mandant value
     * @param string $mandant
     * @return \StructType\Artikelstamm
     */
    public function setMandant($mandant = null)
    {
        // validation for constraint: string
        if (!is_null($mandant) && !is_string($mandant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mandant, true), gettype($mandant)), __LINE__);
        }
        $this->mandant = $mandant;
        return $this;
    }
    /**
     * Get sachnummer value
     * @return string|null
     */
    public function getSachnummer()
    {
        return $this->sachnummer;
    }
    /**
     * Set sachnummer value
     * @param string $sachnummer
     * @return \StructType\Artikelstamm
     */
    public function setSachnummer($sachnummer = null)
    {
        // validation for constraint: string
        if (!is_null($sachnummer) && !is_string($sachnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sachnummer, true), gettype($sachnummer)), __LINE__);
        }
        $this->sachnummer = $sachnummer;
        return $this;
    }
    /**
     * Get sachbezeichnung value
     * @return string|null
     */
    public function getSachbezeichnung()
    {
        return $this->sachbezeichnung;
    }
    /**
     * Set sachbezeichnung value
     * @param string $sachbezeichnung
     * @return \StructType\Artikelstamm
     */
    public function setSachbezeichnung($sachbezeichnung = null)
    {
        // validation for constraint: string
        if (!is_null($sachbezeichnung) && !is_string($sachbezeichnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sachbezeichnung, true), gettype($sachbezeichnung)), __LINE__);
        }
        $this->sachbezeichnung = $sachbezeichnung;
        return $this;
    }
    /**
     * Get mengeneinheit value
     * @return string|null
     */
    public function getMengeneinheit()
    {
        return $this->mengeneinheit;
    }
    /**
     * Set mengeneinheit value
     * @param string $mengeneinheit
     * @return \StructType\Artikelstamm
     */
    public function setMengeneinheit($mengeneinheit = null)
    {
        // validation for constraint: string
        if (!is_null($mengeneinheit) && !is_string($mengeneinheit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mengeneinheit, true), gettype($mengeneinheit)), __LINE__);
        }
        $this->mengeneinheit = $mengeneinheit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Artikelstamm
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
