<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDispatchnotice ArrayType
 * @subpackage Arrays
 */
class ArrayOfDispatchnotice extends AbstractStructArrayBase
{
    /**
     * The Dispatchnotice
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Dispatchnotice[]
     */
    public $Dispatchnotice;
    /**
     * Constructor method for ArrayOfDispatchnotice
     * @uses ArrayOfDispatchnotice::setDispatchnotice()
     * @param \StructType\Dispatchnotice[] $dispatchnotice
     */
    public function __construct(array $dispatchnotice = array())
    {
        $this
            ->setDispatchnotice($dispatchnotice);
    }
    /**
     * Get Dispatchnotice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Dispatchnotice[]|null
     */
    public function getDispatchnotice()
    {
        return isset($this->Dispatchnotice) ? $this->Dispatchnotice : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDispatchnotice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDispatchnotice method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDispatchnoticeForArrayConstraintsFromSetDispatchnotice(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDispatchnoticeDispatchnoticeItem) {
            // validation for constraint: itemType
            if (!$arrayOfDispatchnoticeDispatchnoticeItem instanceof \StructType\Dispatchnotice) {
                $invalidValues[] = is_object($arrayOfDispatchnoticeDispatchnoticeItem) ? get_class($arrayOfDispatchnoticeDispatchnoticeItem) : sprintf('%s(%s)', gettype($arrayOfDispatchnoticeDispatchnoticeItem), var_export($arrayOfDispatchnoticeDispatchnoticeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Dispatchnotice property can only contain items of type \StructType\Dispatchnotice, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Dispatchnotice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Dispatchnotice[] $dispatchnotice
     * @return \ArrayType\ArrayOfDispatchnotice
     */
    public function setDispatchnotice(array $dispatchnotice = array())
    {
        // validation for constraint: array
        if ('' !== ($dispatchnoticeArrayErrorMessage = self::validateDispatchnoticeForArrayConstraintsFromSetDispatchnotice($dispatchnotice))) {
            throw new \InvalidArgumentException($dispatchnoticeArrayErrorMessage, __LINE__);
        }
        if (is_null($dispatchnotice) || (is_array($dispatchnotice) && empty($dispatchnotice))) {
            unset($this->Dispatchnotice);
        } else {
            $this->Dispatchnotice = $dispatchnotice;
        }
        return $this;
    }
    /**
     * Add item to Dispatchnotice value
     * @throws \InvalidArgumentException
     * @param \StructType\Dispatchnotice $item
     * @return \ArrayType\ArrayOfDispatchnotice
     */
    public function addToDispatchnotice(\StructType\Dispatchnotice $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Dispatchnotice) {
            throw new \InvalidArgumentException(sprintf('The Dispatchnotice property can only contain items of type \StructType\Dispatchnotice, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Dispatchnotice[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Dispatchnotice|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Dispatchnotice|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Dispatchnotice|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Dispatchnotice|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Dispatchnotice|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Dispatchnotice
     */
    public function getAttributeName()
    {
        return 'Dispatchnotice';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDispatchnotice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
