<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://gate.wehner-logistics.de:9081/HWPInterface.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://gate.wehner-logistics.de:9081/HWPInterface.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Artikelstamm ServiceType
 */
$artikelstamm = new \ServiceType\Artikelstamm($options);
/**
 * Sample call for Artikelstamm operation/method
 */
if ($artikelstamm->Artikelstamm(new \StructType\Artikelstamm()) !== false) {
    print_r($artikelstamm->getResult());
} else {
    print_r($artikelstamm->getLastError());
}
/**
 * Samples for Bestellung ServiceType
 */
$bestellung = new \ServiceType\Bestellung($options);
/**
 * Sample call for Bestellung operation/method
 */
if ($bestellung->Bestellung(new \StructType\Bestellung()) !== false) {
    print_r($bestellung->getResult());
} else {
    print_r($bestellung->getLastError());
}
/**
 * Samples for Trackingnummern ServiceType
 */
$trackingnummern = new \ServiceType\Trackingnummern($options);
/**
 * Sample call for Trackingnummern operation/method
 */
if ($trackingnummern->Trackingnummern(new \StructType\Trackingnummern()) !== false) {
    print_r($trackingnummern->getResult());
} else {
    print_r($trackingnummern->getLastError());
}
/**
 * Samples for Retouren ServiceType
 */
$retouren = new \ServiceType\Retouren($options);
/**
 * Sample call for Retouren operation/method
 */
if ($retouren->Retouren(new \StructType\Retouren()) !== false) {
    print_r($retouren->getResult());
} else {
    print_r($retouren->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetCustomStatusCode operation/method
 */
if ($get->GetCustomStatusCode(new \StructType\GetCustomStatusCode()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Setartikelstamm ServiceType
 */
$setartikelstamm = new \ServiceType\Setartikelstamm($options);
/**
 * Sample call for setartikelstamm operation/method
 */
if ($setartikelstamm->setartikelstamm(new \StructType\Setartikelstamm()) !== false) {
    print_r($setartikelstamm->getResult());
} else {
    print_r($setartikelstamm->getLastError());
}
