<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Retourepositionen StructType
 * @subpackage Structs
 */
class Retourepositionen extends AbstractStructBase
{
    /**
     * The retoure_menge
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $retoure_menge;
    /**
     * The wiedereinlagerung
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $wiedereinlagerung;
    /**
     * The sachnummer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sachnummer;
    /**
     * The zustand
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $zustand;
    /**
     * Constructor method for Retourepositionen
     * @uses Retourepositionen::setRetoure_menge()
     * @uses Retourepositionen::setWiedereinlagerung()
     * @uses Retourepositionen::setSachnummer()
     * @uses Retourepositionen::setZustand()
     * @param float $retoure_menge
     * @param bool $wiedereinlagerung
     * @param string $sachnummer
     * @param string $zustand
     */
    public function __construct($retoure_menge = null, $wiedereinlagerung = null, $sachnummer = null, $zustand = null)
    {
        $this
            ->setRetoure_menge($retoure_menge)
            ->setWiedereinlagerung($wiedereinlagerung)
            ->setSachnummer($sachnummer)
            ->setZustand($zustand);
    }
    /**
     * Get retoure_menge value
     * @return float
     */
    public function getRetoure_menge()
    {
        return $this->retoure_menge;
    }
    /**
     * Set retoure_menge value
     * @param float $retoure_menge
     * @return \StructType\Retourepositionen
     */
    public function setRetoure_menge($retoure_menge = null)
    {
        // validation for constraint: float
        if (!is_null($retoure_menge) && !(is_float($retoure_menge) || is_numeric($retoure_menge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($retoure_menge, true), gettype($retoure_menge)), __LINE__);
        }
        $this->retoure_menge = $retoure_menge;
        return $this;
    }
    /**
     * Get wiedereinlagerung value
     * @return bool
     */
    public function getWiedereinlagerung()
    {
        return $this->wiedereinlagerung;
    }
    /**
     * Set wiedereinlagerung value
     * @param bool $wiedereinlagerung
     * @return \StructType\Retourepositionen
     */
    public function setWiedereinlagerung($wiedereinlagerung = null)
    {
        // validation for constraint: boolean
        if (!is_null($wiedereinlagerung) && !is_bool($wiedereinlagerung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($wiedereinlagerung, true), gettype($wiedereinlagerung)), __LINE__);
        }
        $this->wiedereinlagerung = $wiedereinlagerung;
        return $this;
    }
    /**
     * Get sachnummer value
     * @return string|null
     */
    public function getSachnummer()
    {
        return $this->sachnummer;
    }
    /**
     * Set sachnummer value
     * @param string $sachnummer
     * @return \StructType\Retourepositionen
     */
    public function setSachnummer($sachnummer = null)
    {
        // validation for constraint: string
        if (!is_null($sachnummer) && !is_string($sachnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sachnummer, true), gettype($sachnummer)), __LINE__);
        }
        $this->sachnummer = $sachnummer;
        return $this;
    }
    /**
     * Get zustand value
     * @return string|null
     */
    public function getZustand()
    {
        return $this->zustand;
    }
    /**
     * Set zustand value
     * @param string $zustand
     * @return \StructType\Retourepositionen
     */
    public function setZustand($zustand = null)
    {
        // validation for constraint: string
        if (!is_null($zustand) && !is_string($zustand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zustand, true), gettype($zustand)), __LINE__);
        }
        $this->zustand = $zustand;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Retourepositionen
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
