<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Retouren StructType
 * @subpackage Structs
 */
class Retouren extends AbstractStructBase
{
    /**
     * The mandant
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mandant;
    /**
     * The auftragsnummer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $auftragsnummer;
    /**
     * The eingangsdatum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $eingangsdatum;
    /**
     * Constructor method for Retouren
     * @uses Retouren::setMandant()
     * @uses Retouren::setAuftragsnummer()
     * @uses Retouren::setEingangsdatum()
     * @param string $mandant
     * @param string $auftragsnummer
     * @param string $eingangsdatum
     */
    public function __construct($mandant = null, $auftragsnummer = null, $eingangsdatum = null)
    {
        $this
            ->setMandant($mandant)
            ->setAuftragsnummer($auftragsnummer)
            ->setEingangsdatum($eingangsdatum);
    }
    /**
     * Get mandant value
     * @return string|null
     */
    public function getMandant()
    {
        return $this->mandant;
    }
    /**
     * Set mandant value
     * @param string $mandant
     * @return \StructType\Retouren
     */
    public function setMandant($mandant = null)
    {
        // validation for constraint: string
        if (!is_null($mandant) && !is_string($mandant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mandant, true), gettype($mandant)), __LINE__);
        }
        $this->mandant = $mandant;
        return $this;
    }
    /**
     * Get auftragsnummer value
     * @return string|null
     */
    public function getAuftragsnummer()
    {
        return $this->auftragsnummer;
    }
    /**
     * Set auftragsnummer value
     * @param string $auftragsnummer
     * @return \StructType\Retouren
     */
    public function setAuftragsnummer($auftragsnummer = null)
    {
        // validation for constraint: string
        if (!is_null($auftragsnummer) && !is_string($auftragsnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($auftragsnummer, true), gettype($auftragsnummer)), __LINE__);
        }
        $this->auftragsnummer = $auftragsnummer;
        return $this;
    }
    /**
     * Get eingangsdatum value
     * @return string|null
     */
    public function getEingangsdatum()
    {
        return $this->eingangsdatum;
    }
    /**
     * Set eingangsdatum value
     * @param string $eingangsdatum
     * @return \StructType\Retouren
     */
    public function setEingangsdatum($eingangsdatum = null)
    {
        // validation for constraint: string
        if (!is_null($eingangsdatum) && !is_string($eingangsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eingangsdatum, true), gettype($eingangsdatum)), __LINE__);
        }
        $this->eingangsdatum = $eingangsdatum;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Retouren
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
