<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Bestellung ServiceType
 * @subpackage Services
 */
class Bestellung extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Bestellung
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Bestellung $parameters
     * @return \StructType\BestellungResponse|bool
     */
    public function Bestellung(\StructType\Bestellung $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Bestellung($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\BestellungResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
