<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfArtikel ArrayType
 * @subpackage Arrays
 */
class ArrayOfArtikel extends AbstractStructArrayBase
{
    /**
     * The artikel
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Artikel[]
     */
    public $artikel;
    /**
     * Constructor method for ArrayOfArtikel
     * @uses ArrayOfArtikel::setArtikel()
     * @param \StructType\Artikel[] $artikel
     */
    public function __construct(array $artikel = array())
    {
        $this
            ->setArtikel($artikel);
    }
    /**
     * Get artikel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Artikel[]|null
     */
    public function getArtikel()
    {
        return isset($this->artikel) ? $this->artikel : null;
    }
    /**
     * This method is responsible for validating the values passed to the setArtikel method
     * This method is willingly generated in order to preserve the one-line inline validation within the setArtikel method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateArtikelForArrayConstraintsFromSetArtikel(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfArtikelArtikelItem) {
            // validation for constraint: itemType
            if (!$arrayOfArtikelArtikelItem instanceof \StructType\Artikel) {
                $invalidValues[] = is_object($arrayOfArtikelArtikelItem) ? get_class($arrayOfArtikelArtikelItem) : sprintf('%s(%s)', gettype($arrayOfArtikelArtikelItem), var_export($arrayOfArtikelArtikelItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The artikel property can only contain items of type \StructType\Artikel, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set artikel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Artikel[] $artikel
     * @return \ArrayType\ArrayOfArtikel
     */
    public function setArtikel(array $artikel = array())
    {
        // validation for constraint: array
        if ('' !== ($artikelArrayErrorMessage = self::validateArtikelForArrayConstraintsFromSetArtikel($artikel))) {
            throw new \InvalidArgumentException($artikelArrayErrorMessage, __LINE__);
        }
        if (is_null($artikel) || (is_array($artikel) && empty($artikel))) {
            unset($this->artikel);
        } else {
            $this->artikel = $artikel;
        }
        return $this;
    }
    /**
     * Add item to artikel value
     * @throws \InvalidArgumentException
     * @param \StructType\Artikel $item
     * @return \ArrayType\ArrayOfArtikel
     */
    public function addToArtikel(\StructType\Artikel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Artikel) {
            throw new \InvalidArgumentException(sprintf('The artikel property can only contain items of type \StructType\Artikel, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->artikel[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Artikel|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Artikel|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Artikel|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Artikel|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Artikel|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string artikel
     */
    public function getAttributeName()
    {
        return 'artikel';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfArtikel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
