<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RedeemableItemPrice StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RedeemableItemPrice
 * @subpackage Structs
 */
class RedeemableItemPrice extends AbstractStructBase
{
    /**
     * The ChannelId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChannelId;
    /**
     * The CustomerTypeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CustomerTypeId;
    /**
     * The DefaultPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $DefaultPrice;
    /**
     * The FidelityLevelId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FidelityLevelId;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The PriceDisabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $PriceDisabled;
    /**
     * The PricePoints
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PricePoints;
    /**
     * The PriceProvisioningAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PriceProvisioningAmount;
    /**
     * The PriceProvisioningPlatformCodeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PriceProvisioningPlatformCodeId;
    /**
     * The ProvisioningPlatformCodeDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProvisioningPlatformCodeDescription;
    /**
     * The RedeemableItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RedeemableItem
     */
    public $RedeemableItem;
    /**
     * The RedeemableItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RedeemableItemId;
    /**
     * The SourceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SourceId;
    /**
     * The ValidFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ValidFrom;
    /**
     * The ValidTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidTo;
    /**
     * The WalletType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WalletType
     */
    public $WalletType;
    /**
     * Constructor method for RedeemableItemPrice
     * @uses RedeemableItemPrice::setChannelId()
     * @uses RedeemableItemPrice::setCustomerTypeId()
     * @uses RedeemableItemPrice::setDefaultPrice()
     * @uses RedeemableItemPrice::setFidelityLevelId()
     * @uses RedeemableItemPrice::setId()
     * @uses RedeemableItemPrice::setPriceDisabled()
     * @uses RedeemableItemPrice::setPricePoints()
     * @uses RedeemableItemPrice::setPriceProvisioningAmount()
     * @uses RedeemableItemPrice::setPriceProvisioningPlatformCodeId()
     * @uses RedeemableItemPrice::setProvisioningPlatformCodeDescription()
     * @uses RedeemableItemPrice::setRedeemableItem()
     * @uses RedeemableItemPrice::setRedeemableItemId()
     * @uses RedeemableItemPrice::setSourceId()
     * @uses RedeemableItemPrice::setValidFrom()
     * @uses RedeemableItemPrice::setValidTo()
     * @uses RedeemableItemPrice::setWalletType()
     * @param string $channelId
     * @param int $customerTypeId
     * @param bool $defaultPrice
     * @param int $fidelityLevelId
     * @param int $id
     * @param bool $priceDisabled
     * @param int $pricePoints
     * @param float $priceProvisioningAmount
     * @param int $priceProvisioningPlatformCodeId
     * @param string $provisioningPlatformCodeDescription
     * @param \StructType\RedeemableItem $redeemableItem
     * @param int $redeemableItemId
     * @param string $sourceId
     * @param string $validFrom
     * @param string $validTo
     * @param \StructType\WalletType $walletType
     */
    public function __construct($channelId = null, $customerTypeId = null, $defaultPrice = null, $fidelityLevelId = null, $id = null, $priceDisabled = null, $pricePoints = null, $priceProvisioningAmount = null, $priceProvisioningPlatformCodeId = null, $provisioningPlatformCodeDescription = null, \StructType\RedeemableItem $redeemableItem = null, $redeemableItemId = null, $sourceId = null, $validFrom = null, $validTo = null, \StructType\WalletType $walletType = null)
    {
        $this
            ->setChannelId($channelId)
            ->setCustomerTypeId($customerTypeId)
            ->setDefaultPrice($defaultPrice)
            ->setFidelityLevelId($fidelityLevelId)
            ->setId($id)
            ->setPriceDisabled($priceDisabled)
            ->setPricePoints($pricePoints)
            ->setPriceProvisioningAmount($priceProvisioningAmount)
            ->setPriceProvisioningPlatformCodeId($priceProvisioningPlatformCodeId)
            ->setProvisioningPlatformCodeDescription($provisioningPlatformCodeDescription)
            ->setRedeemableItem($redeemableItem)
            ->setRedeemableItemId($redeemableItemId)
            ->setSourceId($sourceId)
            ->setValidFrom($validFrom)
            ->setValidTo($validTo)
            ->setWalletType($walletType);
    }
    /**
     * Get ChannelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChannelId()
    {
        return isset($this->ChannelId) ? $this->ChannelId : null;
    }
    /**
     * Set ChannelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $channelId
     * @return \StructType\RedeemableItemPrice
     */
    public function setChannelId($channelId = null)
    {
        // validation for constraint: string
        if (!is_null($channelId) && !is_string($channelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($channelId, true), gettype($channelId)), __LINE__);
        }
        if (is_null($channelId) || (is_array($channelId) && empty($channelId))) {
            unset($this->ChannelId);
        } else {
            $this->ChannelId = $channelId;
        }
        return $this;
    }
    /**
     * Get CustomerTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCustomerTypeId()
    {
        return isset($this->CustomerTypeId) ? $this->CustomerTypeId : null;
    }
    /**
     * Set CustomerTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $customerTypeId
     * @return \StructType\RedeemableItemPrice
     */
    public function setCustomerTypeId($customerTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($customerTypeId) && !(is_int($customerTypeId) || ctype_digit($customerTypeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerTypeId, true), gettype($customerTypeId)), __LINE__);
        }
        if (is_null($customerTypeId) || (is_array($customerTypeId) && empty($customerTypeId))) {
            unset($this->CustomerTypeId);
        } else {
            $this->CustomerTypeId = $customerTypeId;
        }
        return $this;
    }
    /**
     * Get DefaultPrice value
     * @return bool|null
     */
    public function getDefaultPrice()
    {
        return $this->DefaultPrice;
    }
    /**
     * Set DefaultPrice value
     * @param bool $defaultPrice
     * @return \StructType\RedeemableItemPrice
     */
    public function setDefaultPrice($defaultPrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($defaultPrice) && !is_bool($defaultPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($defaultPrice, true), gettype($defaultPrice)), __LINE__);
        }
        $this->DefaultPrice = $defaultPrice;
        return $this;
    }
    /**
     * Get FidelityLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFidelityLevelId()
    {
        return isset($this->FidelityLevelId) ? $this->FidelityLevelId : null;
    }
    /**
     * Set FidelityLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $fidelityLevelId
     * @return \StructType\RedeemableItemPrice
     */
    public function setFidelityLevelId($fidelityLevelId = null)
    {
        // validation for constraint: int
        if (!is_null($fidelityLevelId) && !(is_int($fidelityLevelId) || ctype_digit($fidelityLevelId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fidelityLevelId, true), gettype($fidelityLevelId)), __LINE__);
        }
        if (is_null($fidelityLevelId) || (is_array($fidelityLevelId) && empty($fidelityLevelId))) {
            unset($this->FidelityLevelId);
        } else {
            $this->FidelityLevelId = $fidelityLevelId;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\RedeemableItemPrice
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get PriceDisabled value
     * @return bool|null
     */
    public function getPriceDisabled()
    {
        return $this->PriceDisabled;
    }
    /**
     * Set PriceDisabled value
     * @param bool $priceDisabled
     * @return \StructType\RedeemableItemPrice
     */
    public function setPriceDisabled($priceDisabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($priceDisabled) && !is_bool($priceDisabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($priceDisabled, true), gettype($priceDisabled)), __LINE__);
        }
        $this->PriceDisabled = $priceDisabled;
        return $this;
    }
    /**
     * Get PricePoints value
     * @return int|null
     */
    public function getPricePoints()
    {
        return $this->PricePoints;
    }
    /**
     * Set PricePoints value
     * @param int $pricePoints
     * @return \StructType\RedeemableItemPrice
     */
    public function setPricePoints($pricePoints = null)
    {
        // validation for constraint: int
        if (!is_null($pricePoints) && !(is_int($pricePoints) || ctype_digit($pricePoints))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pricePoints, true), gettype($pricePoints)), __LINE__);
        }
        $this->PricePoints = $pricePoints;
        return $this;
    }
    /**
     * Get PriceProvisioningAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPriceProvisioningAmount()
    {
        return isset($this->PriceProvisioningAmount) ? $this->PriceProvisioningAmount : null;
    }
    /**
     * Set PriceProvisioningAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $priceProvisioningAmount
     * @return \StructType\RedeemableItemPrice
     */
    public function setPriceProvisioningAmount($priceProvisioningAmount = null)
    {
        // validation for constraint: float
        if (!is_null($priceProvisioningAmount) && !(is_float($priceProvisioningAmount) || is_numeric($priceProvisioningAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($priceProvisioningAmount, true), gettype($priceProvisioningAmount)), __LINE__);
        }
        if (is_null($priceProvisioningAmount) || (is_array($priceProvisioningAmount) && empty($priceProvisioningAmount))) {
            unset($this->PriceProvisioningAmount);
        } else {
            $this->PriceProvisioningAmount = $priceProvisioningAmount;
        }
        return $this;
    }
    /**
     * Get PriceProvisioningPlatformCodeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriceProvisioningPlatformCodeId()
    {
        return isset($this->PriceProvisioningPlatformCodeId) ? $this->PriceProvisioningPlatformCodeId : null;
    }
    /**
     * Set PriceProvisioningPlatformCodeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priceProvisioningPlatformCodeId
     * @return \StructType\RedeemableItemPrice
     */
    public function setPriceProvisioningPlatformCodeId($priceProvisioningPlatformCodeId = null)
    {
        // validation for constraint: int
        if (!is_null($priceProvisioningPlatformCodeId) && !(is_int($priceProvisioningPlatformCodeId) || ctype_digit($priceProvisioningPlatformCodeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priceProvisioningPlatformCodeId, true), gettype($priceProvisioningPlatformCodeId)), __LINE__);
        }
        if (is_null($priceProvisioningPlatformCodeId) || (is_array($priceProvisioningPlatformCodeId) && empty($priceProvisioningPlatformCodeId))) {
            unset($this->PriceProvisioningPlatformCodeId);
        } else {
            $this->PriceProvisioningPlatformCodeId = $priceProvisioningPlatformCodeId;
        }
        return $this;
    }
    /**
     * Get ProvisioningPlatformCodeDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProvisioningPlatformCodeDescription()
    {
        return isset($this->ProvisioningPlatformCodeDescription) ? $this->ProvisioningPlatformCodeDescription : null;
    }
    /**
     * Set ProvisioningPlatformCodeDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $provisioningPlatformCodeDescription
     * @return \StructType\RedeemableItemPrice
     */
    public function setProvisioningPlatformCodeDescription($provisioningPlatformCodeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($provisioningPlatformCodeDescription) && !is_string($provisioningPlatformCodeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provisioningPlatformCodeDescription, true), gettype($provisioningPlatformCodeDescription)), __LINE__);
        }
        if (is_null($provisioningPlatformCodeDescription) || (is_array($provisioningPlatformCodeDescription) && empty($provisioningPlatformCodeDescription))) {
            unset($this->ProvisioningPlatformCodeDescription);
        } else {
            $this->ProvisioningPlatformCodeDescription = $provisioningPlatformCodeDescription;
        }
        return $this;
    }
    /**
     * Get RedeemableItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RedeemableItem|null
     */
    public function getRedeemableItem()
    {
        return isset($this->RedeemableItem) ? $this->RedeemableItem : null;
    }
    /**
     * Set RedeemableItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RedeemableItem $redeemableItem
     * @return \StructType\RedeemableItemPrice
     */
    public function setRedeemableItem(\StructType\RedeemableItem $redeemableItem = null)
    {
        if (is_null($redeemableItem) || (is_array($redeemableItem) && empty($redeemableItem))) {
            unset($this->RedeemableItem);
        } else {
            $this->RedeemableItem = $redeemableItem;
        }
        return $this;
    }
    /**
     * Get RedeemableItemId value
     * @return int|null
     */
    public function getRedeemableItemId()
    {
        return $this->RedeemableItemId;
    }
    /**
     * Set RedeemableItemId value
     * @param int $redeemableItemId
     * @return \StructType\RedeemableItemPrice
     */
    public function setRedeemableItemId($redeemableItemId = null)
    {
        // validation for constraint: int
        if (!is_null($redeemableItemId) && !(is_int($redeemableItemId) || ctype_digit($redeemableItemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($redeemableItemId, true), gettype($redeemableItemId)), __LINE__);
        }
        $this->RedeemableItemId = $redeemableItemId;
        return $this;
    }
    /**
     * Get SourceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceId()
    {
        return isset($this->SourceId) ? $this->SourceId : null;
    }
    /**
     * Set SourceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sourceId
     * @return \StructType\RedeemableItemPrice
     */
    public function setSourceId($sourceId = null)
    {
        // validation for constraint: string
        if (!is_null($sourceId) && !is_string($sourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceId, true), gettype($sourceId)), __LINE__);
        }
        if (is_null($sourceId) || (is_array($sourceId) && empty($sourceId))) {
            unset($this->SourceId);
        } else {
            $this->SourceId = $sourceId;
        }
        return $this;
    }
    /**
     * Get ValidFrom value
     * @return string|null
     */
    public function getValidFrom()
    {
        return $this->ValidFrom;
    }
    /**
     * Set ValidFrom value
     * @param string $validFrom
     * @return \StructType\RedeemableItemPrice
     */
    public function setValidFrom($validFrom = null)
    {
        // validation for constraint: string
        if (!is_null($validFrom) && !is_string($validFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validFrom, true), gettype($validFrom)), __LINE__);
        }
        $this->ValidFrom = $validFrom;
        return $this;
    }
    /**
     * Get ValidTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidTo()
    {
        return isset($this->ValidTo) ? $this->ValidTo : null;
    }
    /**
     * Set ValidTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validTo
     * @return \StructType\RedeemableItemPrice
     */
    public function setValidTo($validTo = null)
    {
        // validation for constraint: string
        if (!is_null($validTo) && !is_string($validTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validTo, true), gettype($validTo)), __LINE__);
        }
        if (is_null($validTo) || (is_array($validTo) && empty($validTo))) {
            unset($this->ValidTo);
        } else {
            $this->ValidTo = $validTo;
        }
        return $this;
    }
    /**
     * Get WalletType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WalletType|null
     */
    public function getWalletType()
    {
        return isset($this->WalletType) ? $this->WalletType : null;
    }
    /**
     * Set WalletType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WalletType $walletType
     * @return \StructType\RedeemableItemPrice
     */
    public function setWalletType(\StructType\WalletType $walletType = null)
    {
        if (is_null($walletType) || (is_array($walletType) && empty($walletType))) {
            unset($this->WalletType);
        } else {
            $this->WalletType = $walletType;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RedeemableItemPrice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
