<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RedeemableItemCatalogue StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RedeemableItemCatalogue
 * @subpackage Structs
 */
class RedeemableItemCatalogue extends AbstractStructBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The RedeemableItemCategories
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfRedeemableItemCategory
     */
    public $RedeemableItemCategories;
    /**
     * The ShortDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShortDescription;
    /**
     * Constructor method for RedeemableItemCatalogue
     * @uses RedeemableItemCatalogue::setDescription()
     * @uses RedeemableItemCatalogue::setId()
     * @uses RedeemableItemCatalogue::setRedeemableItemCategories()
     * @uses RedeemableItemCatalogue::setShortDescription()
     * @param string $description
     * @param int $id
     * @param \ArrayType\ArrayOfRedeemableItemCategory $redeemableItemCategories
     * @param string $shortDescription
     */
    public function __construct($description = null, $id = null, \ArrayType\ArrayOfRedeemableItemCategory $redeemableItemCategories = null, $shortDescription = null)
    {
        $this
            ->setDescription($description)
            ->setId($id)
            ->setRedeemableItemCategories($redeemableItemCategories)
            ->setShortDescription($shortDescription);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\RedeemableItemCatalogue
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\RedeemableItemCatalogue
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get RedeemableItemCategories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfRedeemableItemCategory|null
     */
    public function getRedeemableItemCategories()
    {
        return isset($this->RedeemableItemCategories) ? $this->RedeemableItemCategories : null;
    }
    /**
     * Set RedeemableItemCategories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfRedeemableItemCategory $redeemableItemCategories
     * @return \StructType\RedeemableItemCatalogue
     */
    public function setRedeemableItemCategories(\ArrayType\ArrayOfRedeemableItemCategory $redeemableItemCategories = null)
    {
        if (is_null($redeemableItemCategories) || (is_array($redeemableItemCategories) && empty($redeemableItemCategories))) {
            unset($this->RedeemableItemCategories);
        } else {
            $this->RedeemableItemCategories = $redeemableItemCategories;
        }
        return $this;
    }
    /**
     * Get ShortDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShortDescription()
    {
        return isset($this->ShortDescription) ? $this->ShortDescription : null;
    }
    /**
     * Set ShortDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shortDescription
     * @return \StructType\RedeemableItemCatalogue
     */
    public function setShortDescription($shortDescription = null)
    {
        // validation for constraint: string
        if (!is_null($shortDescription) && !is_string($shortDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shortDescription, true), gettype($shortDescription)), __LINE__);
        }
        if (is_null($shortDescription) || (is_array($shortDescription) && empty($shortDescription))) {
            unset($this->ShortDescription);
        } else {
            $this->ShortDescription = $shortDescription;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RedeemableItemCatalogue
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
