<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PurchaseOrderItemInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PurchaseOrderItemInfo
 * @subpackage Structs
 */
class PurchaseOrderItemInfo extends AbstractStructBase
{
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Error
     */
    public $Error;
    /**
     * The RedeemableItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RedeemableItemId;
    /**
     * The WalletType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WalletType
     */
    public $WalletType;
    /**
     * Constructor method for PurchaseOrderItemInfo
     * @uses PurchaseOrderItemInfo::setError()
     * @uses PurchaseOrderItemInfo::setRedeemableItemId()
     * @uses PurchaseOrderItemInfo::setWalletType()
     * @param \StructType\Error $error
     * @param int $redeemableItemId
     * @param \StructType\WalletType $walletType
     */
    public function __construct(\StructType\Error $error = null, $redeemableItemId = null, \StructType\WalletType $walletType = null)
    {
        $this
            ->setError($error)
            ->setRedeemableItemId($redeemableItemId)
            ->setWalletType($walletType);
    }
    /**
     * Get Error value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Error|null
     */
    public function getError()
    {
        return isset($this->Error) ? $this->Error : null;
    }
    /**
     * Set Error value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Error $error
     * @return \StructType\PurchaseOrderItemInfo
     */
    public function setError(\StructType\Error $error = null)
    {
        if (is_null($error) || (is_array($error) && empty($error))) {
            unset($this->Error);
        } else {
            $this->Error = $error;
        }
        return $this;
    }
    /**
     * Get RedeemableItemId value
     * @return int|null
     */
    public function getRedeemableItemId()
    {
        return $this->RedeemableItemId;
    }
    /**
     * Set RedeemableItemId value
     * @param int $redeemableItemId
     * @return \StructType\PurchaseOrderItemInfo
     */
    public function setRedeemableItemId($redeemableItemId = null)
    {
        // validation for constraint: int
        if (!is_null($redeemableItemId) && !(is_int($redeemableItemId) || ctype_digit($redeemableItemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($redeemableItemId, true), gettype($redeemableItemId)), __LINE__);
        }
        $this->RedeemableItemId = $redeemableItemId;
        return $this;
    }
    /**
     * Get WalletType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WalletType|null
     */
    public function getWalletType()
    {
        return isset($this->WalletType) ? $this->WalletType : null;
    }
    /**
     * Set WalletType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WalletType $walletType
     * @return \StructType\PurchaseOrderItemInfo
     */
    public function setWalletType(\StructType\WalletType $walletType = null)
    {
        if (is_null($walletType) || (is_array($walletType) && empty($walletType))) {
            unset($this->WalletType);
        } else {
            $this->WalletType = $walletType;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PurchaseOrderItemInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
