<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PasswordRequest StructType
 * @subpackage Structs
 */
class PasswordRequest extends AbstractStructBase
{
    /**
     * The subscriberId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $subscriberId;
    /**
     * The subscriberIdType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $subscriberIdType;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $password;
    /**
     * The language
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $language;
    /**
     * Constructor method for PasswordRequest
     * @uses PasswordRequest::setSubscriberId()
     * @uses PasswordRequest::setSubscriberIdType()
     * @uses PasswordRequest::setPassword()
     * @uses PasswordRequest::setLanguage()
     * @param string $subscriberId
     * @param string $subscriberIdType
     * @param string $password
     * @param string $language
     */
    public function __construct($subscriberId = null, $subscriberIdType = null, $password = null, $language = null)
    {
        $this
            ->setSubscriberId($subscriberId)
            ->setSubscriberIdType($subscriberIdType)
            ->setPassword($password)
            ->setLanguage($language);
    }
    /**
     * Get subscriberId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriberId()
    {
        return isset($this->subscriberId) ? $this->subscriberId : null;
    }
    /**
     * Set subscriberId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriberId
     * @return \StructType\PasswordRequest
     */
    public function setSubscriberId($subscriberId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriberId) && !is_string($subscriberId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriberId, true), gettype($subscriberId)), __LINE__);
        }
        if (is_null($subscriberId) || (is_array($subscriberId) && empty($subscriberId))) {
            unset($this->subscriberId);
        } else {
            $this->subscriberId = $subscriberId;
        }
        return $this;
    }
    /**
     * Get subscriberIdType value
     * @return string|null
     */
    public function getSubscriberIdType()
    {
        return $this->subscriberIdType;
    }
    /**
     * Set subscriberIdType value
     * @uses \EnumType\ParamType::valueIsValid()
     * @uses \EnumType\ParamType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subscriberIdType
     * @return \StructType\PasswordRequest
     */
    public function setSubscriberIdType($subscriberIdType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ParamType::valueIsValid($subscriberIdType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ParamType', is_array($subscriberIdType) ? implode(', ', $subscriberIdType) : var_export($subscriberIdType, true), implode(', ', \EnumType\ParamType::getValidValues())), __LINE__);
        }
        $this->subscriberIdType = $subscriberIdType;
        return $this;
    }
    /**
     * Get password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassword()
    {
        return isset($this->password) ? $this->password : null;
    }
    /**
     * Set password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $password
     * @return \StructType\PasswordRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        if (is_null($password) || (is_array($password) && empty($password))) {
            unset($this->password);
        } else {
            $this->password = $password;
        }
        return $this;
    }
    /**
     * Get language value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLanguage()
    {
        return isset($this->language) ? $this->language : null;
    }
    /**
     * Set language value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $language
     * @return \StructType\PasswordRequest
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        if (is_null($language) || (is_array($language) && empty($language))) {
            unset($this->language);
        } else {
            $this->language = $language;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PasswordRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
