<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCataloguesSummary StructType
 * @subpackage Structs
 */
class GetCataloguesSummary extends AbstractStructBase
{
    /**
     * The source
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $source;
    /**
     * The channel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $channel;
    /**
     * The externalReferenceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $externalReferenceId;
    /**
     * The language
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $language;
    /**
     * The subscriberId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $subscriberId;
    /**
     * The subscriberIdType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $subscriberIdType;
    /**
     * The walletTypeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $walletTypeId;
    /**
     * The redeemableItemCatalogueId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $redeemableItemCatalogueId;
    /**
     * The redeemableItemCategoryId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $redeemableItemCategoryId;
    /**
     * Constructor method for GetCataloguesSummary
     * @uses GetCataloguesSummary::setSource()
     * @uses GetCataloguesSummary::setChannel()
     * @uses GetCataloguesSummary::setExternalReferenceId()
     * @uses GetCataloguesSummary::setLanguage()
     * @uses GetCataloguesSummary::setSubscriberId()
     * @uses GetCataloguesSummary::setSubscriberIdType()
     * @uses GetCataloguesSummary::setWalletTypeId()
     * @uses GetCataloguesSummary::setRedeemableItemCatalogueId()
     * @uses GetCataloguesSummary::setRedeemableItemCategoryId()
     * @param string $source
     * @param string $channel
     * @param int $externalReferenceId
     * @param string $language
     * @param string $subscriberId
     * @param string $subscriberIdType
     * @param int $walletTypeId
     * @param int $redeemableItemCatalogueId
     * @param int $redeemableItemCategoryId
     */
    public function __construct($source = null, $channel = null, $externalReferenceId = null, $language = null, $subscriberId = null, $subscriberIdType = null, $walletTypeId = null, $redeemableItemCatalogueId = null, $redeemableItemCategoryId = null)
    {
        $this
            ->setSource($source)
            ->setChannel($channel)
            ->setExternalReferenceId($externalReferenceId)
            ->setLanguage($language)
            ->setSubscriberId($subscriberId)
            ->setSubscriberIdType($subscriberIdType)
            ->setWalletTypeId($walletTypeId)
            ->setRedeemableItemCatalogueId($redeemableItemCatalogueId)
            ->setRedeemableItemCategoryId($redeemableItemCategoryId);
    }
    /**
     * Get source value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSource()
    {
        return isset($this->source) ? $this->source : null;
    }
    /**
     * Set source value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $source
     * @return \StructType\GetCataloguesSummary
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source, true), gettype($source)), __LINE__);
        }
        if (is_null($source) || (is_array($source) && empty($source))) {
            unset($this->source);
        } else {
            $this->source = $source;
        }
        return $this;
    }
    /**
     * Get channel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChannel()
    {
        return isset($this->channel) ? $this->channel : null;
    }
    /**
     * Set channel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $channel
     * @return \StructType\GetCataloguesSummary
     */
    public function setChannel($channel = null)
    {
        // validation for constraint: string
        if (!is_null($channel) && !is_string($channel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($channel, true), gettype($channel)), __LINE__);
        }
        if (is_null($channel) || (is_array($channel) && empty($channel))) {
            unset($this->channel);
        } else {
            $this->channel = $channel;
        }
        return $this;
    }
    /**
     * Get externalReferenceId value
     * @return int|null
     */
    public function getExternalReferenceId()
    {
        return $this->externalReferenceId;
    }
    /**
     * Set externalReferenceId value
     * @param int $externalReferenceId
     * @return \StructType\GetCataloguesSummary
     */
    public function setExternalReferenceId($externalReferenceId = null)
    {
        // validation for constraint: int
        if (!is_null($externalReferenceId) && !(is_int($externalReferenceId) || ctype_digit($externalReferenceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($externalReferenceId, true), gettype($externalReferenceId)), __LINE__);
        }
        $this->externalReferenceId = $externalReferenceId;
        return $this;
    }
    /**
     * Get language value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLanguage()
    {
        return isset($this->language) ? $this->language : null;
    }
    /**
     * Set language value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $language
     * @return \StructType\GetCataloguesSummary
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        if (is_null($language) || (is_array($language) && empty($language))) {
            unset($this->language);
        } else {
            $this->language = $language;
        }
        return $this;
    }
    /**
     * Get subscriberId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriberId()
    {
        return isset($this->subscriberId) ? $this->subscriberId : null;
    }
    /**
     * Set subscriberId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriberId
     * @return \StructType\GetCataloguesSummary
     */
    public function setSubscriberId($subscriberId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriberId) && !is_string($subscriberId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriberId, true), gettype($subscriberId)), __LINE__);
        }
        if (is_null($subscriberId) || (is_array($subscriberId) && empty($subscriberId))) {
            unset($this->subscriberId);
        } else {
            $this->subscriberId = $subscriberId;
        }
        return $this;
    }
    /**
     * Get subscriberIdType value
     * @return string|null
     */
    public function getSubscriberIdType()
    {
        return $this->subscriberIdType;
    }
    /**
     * Set subscriberIdType value
     * @uses \EnumType\ParamType::valueIsValid()
     * @uses \EnumType\ParamType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subscriberIdType
     * @return \StructType\GetCataloguesSummary
     */
    public function setSubscriberIdType($subscriberIdType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ParamType::valueIsValid($subscriberIdType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ParamType', is_array($subscriberIdType) ? implode(', ', $subscriberIdType) : var_export($subscriberIdType, true), implode(', ', \EnumType\ParamType::getValidValues())), __LINE__);
        }
        $this->subscriberIdType = $subscriberIdType;
        return $this;
    }
    /**
     * Get walletTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getWalletTypeId()
    {
        return isset($this->walletTypeId) ? $this->walletTypeId : null;
    }
    /**
     * Set walletTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $walletTypeId
     * @return \StructType\GetCataloguesSummary
     */
    public function setWalletTypeId($walletTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($walletTypeId) && !(is_int($walletTypeId) || ctype_digit($walletTypeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($walletTypeId, true), gettype($walletTypeId)), __LINE__);
        }
        if (is_null($walletTypeId) || (is_array($walletTypeId) && empty($walletTypeId))) {
            unset($this->walletTypeId);
        } else {
            $this->walletTypeId = $walletTypeId;
        }
        return $this;
    }
    /**
     * Get redeemableItemCatalogueId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRedeemableItemCatalogueId()
    {
        return isset($this->redeemableItemCatalogueId) ? $this->redeemableItemCatalogueId : null;
    }
    /**
     * Set redeemableItemCatalogueId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $redeemableItemCatalogueId
     * @return \StructType\GetCataloguesSummary
     */
    public function setRedeemableItemCatalogueId($redeemableItemCatalogueId = null)
    {
        // validation for constraint: int
        if (!is_null($redeemableItemCatalogueId) && !(is_int($redeemableItemCatalogueId) || ctype_digit($redeemableItemCatalogueId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($redeemableItemCatalogueId, true), gettype($redeemableItemCatalogueId)), __LINE__);
        }
        if (is_null($redeemableItemCatalogueId) || (is_array($redeemableItemCatalogueId) && empty($redeemableItemCatalogueId))) {
            unset($this->redeemableItemCatalogueId);
        } else {
            $this->redeemableItemCatalogueId = $redeemableItemCatalogueId;
        }
        return $this;
    }
    /**
     * Get redeemableItemCategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRedeemableItemCategoryId()
    {
        return isset($this->redeemableItemCategoryId) ? $this->redeemableItemCategoryId : null;
    }
    /**
     * Set redeemableItemCategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $redeemableItemCategoryId
     * @return \StructType\GetCataloguesSummary
     */
    public function setRedeemableItemCategoryId($redeemableItemCategoryId = null)
    {
        // validation for constraint: int
        if (!is_null($redeemableItemCategoryId) && !(is_int($redeemableItemCategoryId) || ctype_digit($redeemableItemCategoryId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($redeemableItemCategoryId, true), gettype($redeemableItemCategoryId)), __LINE__);
        }
        if (is_null($redeemableItemCategoryId) || (is_array($redeemableItemCategoryId) && empty($redeemableItemCategoryId))) {
            unset($this->redeemableItemCategoryId);
        } else {
            $this->redeemableItemCategoryId = $redeemableItemCategoryId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCataloguesSummary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
