<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryChannel StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DeliveryChannel
 * @subpackage Structs
 */
class DeliveryChannel extends AbstractStructBase
{
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AreaId;
    /**
     * The DeliveryChannelTypeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DeliveryChannelTypeId;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The Enabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Enabled;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The ShortDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShortDescription;
    /**
     * Constructor method for DeliveryChannel
     * @uses DeliveryChannel::setAreaId()
     * @uses DeliveryChannel::setDeliveryChannelTypeId()
     * @uses DeliveryChannel::setDescription()
     * @uses DeliveryChannel::setEnabled()
     * @uses DeliveryChannel::setId()
     * @uses DeliveryChannel::setShortDescription()
     * @param int $areaId
     * @param int $deliveryChannelTypeId
     * @param string $description
     * @param bool $enabled
     * @param int $id
     * @param string $shortDescription
     */
    public function __construct($areaId = null, $deliveryChannelTypeId = null, $description = null, $enabled = null, $id = null, $shortDescription = null)
    {
        $this
            ->setAreaId($areaId)
            ->setDeliveryChannelTypeId($deliveryChannelTypeId)
            ->setDescription($description)
            ->setEnabled($enabled)
            ->setId($id)
            ->setShortDescription($shortDescription);
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $areaId
     * @return \StructType\DeliveryChannel
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: int
        if (!is_null($areaId) && !(is_int($areaId) || ctype_digit($areaId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get DeliveryChannelTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDeliveryChannelTypeId()
    {
        return isset($this->DeliveryChannelTypeId) ? $this->DeliveryChannelTypeId : null;
    }
    /**
     * Set DeliveryChannelTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $deliveryChannelTypeId
     * @return \StructType\DeliveryChannel
     */
    public function setDeliveryChannelTypeId($deliveryChannelTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($deliveryChannelTypeId) && !(is_int($deliveryChannelTypeId) || ctype_digit($deliveryChannelTypeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deliveryChannelTypeId, true), gettype($deliveryChannelTypeId)), __LINE__);
        }
        if (is_null($deliveryChannelTypeId) || (is_array($deliveryChannelTypeId) && empty($deliveryChannelTypeId))) {
            unset($this->DeliveryChannelTypeId);
        } else {
            $this->DeliveryChannelTypeId = $deliveryChannelTypeId;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\DeliveryChannel
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Enabled value
     * @return bool|null
     */
    public function getEnabled()
    {
        return $this->Enabled;
    }
    /**
     * Set Enabled value
     * @param bool $enabled
     * @return \StructType\DeliveryChannel
     */
    public function setEnabled($enabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($enabled) && !is_bool($enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enabled, true), gettype($enabled)), __LINE__);
        }
        $this->Enabled = $enabled;
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\DeliveryChannel
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get ShortDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShortDescription()
    {
        return isset($this->ShortDescription) ? $this->ShortDescription : null;
    }
    /**
     * Set ShortDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shortDescription
     * @return \StructType\DeliveryChannel
     */
    public function setShortDescription($shortDescription = null)
    {
        // validation for constraint: string
        if (!is_null($shortDescription) && !is_string($shortDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shortDescription, true), gettype($shortDescription)), __LINE__);
        }
        if (is_null($shortDescription) || (is_array($shortDescription) && empty($shortDescription))) {
            unset($this->ShortDescription);
        } else {
            $this->ShortDescription = $shortDescription;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeliveryChannel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
