<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommandPriceResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CommandPriceResponse
 * @subpackage Structs
 */
class CommandPriceResponse extends ApiResponse
{
    /**
     * The PricePoints
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PricePoints;
    /**
     * The ProvisioningAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ProvisioningAmount;
    /**
     * The ProvisioningPlatformCodeDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProvisioningPlatformCodeDescription;
    /**
     * The ProvisioningPlatformCodeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ProvisioningPlatformCodeId;
    /**
     * Constructor method for CommandPriceResponse
     * @uses CommandPriceResponse::setPricePoints()
     * @uses CommandPriceResponse::setProvisioningAmount()
     * @uses CommandPriceResponse::setProvisioningPlatformCodeDescription()
     * @uses CommandPriceResponse::setProvisioningPlatformCodeId()
     * @param int $pricePoints
     * @param float $provisioningAmount
     * @param string $provisioningPlatformCodeDescription
     * @param int $provisioningPlatformCodeId
     */
    public function __construct($pricePoints = null, $provisioningAmount = null, $provisioningPlatformCodeDescription = null, $provisioningPlatformCodeId = null)
    {
        $this
            ->setPricePoints($pricePoints)
            ->setProvisioningAmount($provisioningAmount)
            ->setProvisioningPlatformCodeDescription($provisioningPlatformCodeDescription)
            ->setProvisioningPlatformCodeId($provisioningPlatformCodeId);
    }
    /**
     * Get PricePoints value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPricePoints()
    {
        return isset($this->PricePoints) ? $this->PricePoints : null;
    }
    /**
     * Set PricePoints value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pricePoints
     * @return \StructType\CommandPriceResponse
     */
    public function setPricePoints($pricePoints = null)
    {
        // validation for constraint: int
        if (!is_null($pricePoints) && !(is_int($pricePoints) || ctype_digit($pricePoints))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pricePoints, true), gettype($pricePoints)), __LINE__);
        }
        if (is_null($pricePoints) || (is_array($pricePoints) && empty($pricePoints))) {
            unset($this->PricePoints);
        } else {
            $this->PricePoints = $pricePoints;
        }
        return $this;
    }
    /**
     * Get ProvisioningAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getProvisioningAmount()
    {
        return isset($this->ProvisioningAmount) ? $this->ProvisioningAmount : null;
    }
    /**
     * Set ProvisioningAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $provisioningAmount
     * @return \StructType\CommandPriceResponse
     */
    public function setProvisioningAmount($provisioningAmount = null)
    {
        // validation for constraint: float
        if (!is_null($provisioningAmount) && !(is_float($provisioningAmount) || is_numeric($provisioningAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($provisioningAmount, true), gettype($provisioningAmount)), __LINE__);
        }
        if (is_null($provisioningAmount) || (is_array($provisioningAmount) && empty($provisioningAmount))) {
            unset($this->ProvisioningAmount);
        } else {
            $this->ProvisioningAmount = $provisioningAmount;
        }
        return $this;
    }
    /**
     * Get ProvisioningPlatformCodeDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProvisioningPlatformCodeDescription()
    {
        return isset($this->ProvisioningPlatformCodeDescription) ? $this->ProvisioningPlatformCodeDescription : null;
    }
    /**
     * Set ProvisioningPlatformCodeDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $provisioningPlatformCodeDescription
     * @return \StructType\CommandPriceResponse
     */
    public function setProvisioningPlatformCodeDescription($provisioningPlatformCodeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($provisioningPlatformCodeDescription) && !is_string($provisioningPlatformCodeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provisioningPlatformCodeDescription, true), gettype($provisioningPlatformCodeDescription)), __LINE__);
        }
        if (is_null($provisioningPlatformCodeDescription) || (is_array($provisioningPlatformCodeDescription) && empty($provisioningPlatformCodeDescription))) {
            unset($this->ProvisioningPlatformCodeDescription);
        } else {
            $this->ProvisioningPlatformCodeDescription = $provisioningPlatformCodeDescription;
        }
        return $this;
    }
    /**
     * Get ProvisioningPlatformCodeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getProvisioningPlatformCodeId()
    {
        return isset($this->ProvisioningPlatformCodeId) ? $this->ProvisioningPlatformCodeId : null;
    }
    /**
     * Set ProvisioningPlatformCodeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $provisioningPlatformCodeId
     * @return \StructType\CommandPriceResponse
     */
    public function setProvisioningPlatformCodeId($provisioningPlatformCodeId = null)
    {
        // validation for constraint: int
        if (!is_null($provisioningPlatformCodeId) && !(is_int($provisioningPlatformCodeId) || ctype_digit($provisioningPlatformCodeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($provisioningPlatformCodeId, true), gettype($provisioningPlatformCodeId)), __LINE__);
        }
        if (is_null($provisioningPlatformCodeId) || (is_array($provisioningPlatformCodeId) && empty($provisioningPlatformCodeId))) {
            unset($this->ProvisioningPlatformCodeId);
        } else {
            $this->ProvisioningPlatformCodeId = $provisioningPlatformCodeId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CommandPriceResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
