<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CataloguesSummaryResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CataloguesSummaryResponse
 * @subpackage Structs
 */
class CataloguesSummaryResponse extends ApiResponse
{
    /**
     * The CataloguseNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CataloguseNumber;
    /**
     * The CategoriesCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CategoriesCount;
    /**
     * The PhysicalItemsNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PhysicalItemsNumber;
    /**
     * The TelecomItemsNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TelecomItemsNumber;
    /**
     * Constructor method for CataloguesSummaryResponse
     * @uses CataloguesSummaryResponse::setCataloguseNumber()
     * @uses CataloguesSummaryResponse::setCategoriesCount()
     * @uses CataloguesSummaryResponse::setPhysicalItemsNumber()
     * @uses CataloguesSummaryResponse::setTelecomItemsNumber()
     * @param int $cataloguseNumber
     * @param int $categoriesCount
     * @param int $physicalItemsNumber
     * @param int $telecomItemsNumber
     */
    public function __construct($cataloguseNumber = null, $categoriesCount = null, $physicalItemsNumber = null, $telecomItemsNumber = null)
    {
        $this
            ->setCataloguseNumber($cataloguseNumber)
            ->setCategoriesCount($categoriesCount)
            ->setPhysicalItemsNumber($physicalItemsNumber)
            ->setTelecomItemsNumber($telecomItemsNumber);
    }
    /**
     * Get CataloguseNumber value
     * @return int|null
     */
    public function getCataloguseNumber()
    {
        return $this->CataloguseNumber;
    }
    /**
     * Set CataloguseNumber value
     * @param int $cataloguseNumber
     * @return \StructType\CataloguesSummaryResponse
     */
    public function setCataloguseNumber($cataloguseNumber = null)
    {
        // validation for constraint: int
        if (!is_null($cataloguseNumber) && !(is_int($cataloguseNumber) || ctype_digit($cataloguseNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cataloguseNumber, true), gettype($cataloguseNumber)), __LINE__);
        }
        $this->CataloguseNumber = $cataloguseNumber;
        return $this;
    }
    /**
     * Get CategoriesCount value
     * @return int|null
     */
    public function getCategoriesCount()
    {
        return $this->CategoriesCount;
    }
    /**
     * Set CategoriesCount value
     * @param int $categoriesCount
     * @return \StructType\CataloguesSummaryResponse
     */
    public function setCategoriesCount($categoriesCount = null)
    {
        // validation for constraint: int
        if (!is_null($categoriesCount) && !(is_int($categoriesCount) || ctype_digit($categoriesCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($categoriesCount, true), gettype($categoriesCount)), __LINE__);
        }
        $this->CategoriesCount = $categoriesCount;
        return $this;
    }
    /**
     * Get PhysicalItemsNumber value
     * @return int|null
     */
    public function getPhysicalItemsNumber()
    {
        return $this->PhysicalItemsNumber;
    }
    /**
     * Set PhysicalItemsNumber value
     * @param int $physicalItemsNumber
     * @return \StructType\CataloguesSummaryResponse
     */
    public function setPhysicalItemsNumber($physicalItemsNumber = null)
    {
        // validation for constraint: int
        if (!is_null($physicalItemsNumber) && !(is_int($physicalItemsNumber) || ctype_digit($physicalItemsNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($physicalItemsNumber, true), gettype($physicalItemsNumber)), __LINE__);
        }
        $this->PhysicalItemsNumber = $physicalItemsNumber;
        return $this;
    }
    /**
     * Get TelecomItemsNumber value
     * @return int|null
     */
    public function getTelecomItemsNumber()
    {
        return $this->TelecomItemsNumber;
    }
    /**
     * Set TelecomItemsNumber value
     * @param int $telecomItemsNumber
     * @return \StructType\CataloguesSummaryResponse
     */
    public function setTelecomItemsNumber($telecomItemsNumber = null)
    {
        // validation for constraint: int
        if (!is_null($telecomItemsNumber) && !(is_int($telecomItemsNumber) || ctype_digit($telecomItemsNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($telecomItemsNumber, true), gettype($telecomItemsNumber)), __LINE__);
        }
        $this->TelecomItemsNumber = $telecomItemsNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CataloguesSummaryResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
