<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BalanceLog StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BalanceLog
 * @subpackage Structs
 */
class BalanceLog extends AbstractStructBase
{
    /**
     * The Channel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Channel;
    /**
     * The CommandDatetime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CommandDatetime;
    /**
     * The CommandDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommandDescription;
    /**
     * The Points
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Points;
    /**
     * The Source
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Source;
    /**
     * The SourceDesc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SourceDesc;
    /**
     * The ValidFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidFrom;
    /**
     * The ValidTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidTo;
    /**
     * The WalletType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WalletType;
    /**
     * Constructor method for BalanceLog
     * @uses BalanceLog::setChannel()
     * @uses BalanceLog::setCommandDatetime()
     * @uses BalanceLog::setCommandDescription()
     * @uses BalanceLog::setPoints()
     * @uses BalanceLog::setSource()
     * @uses BalanceLog::setSourceDesc()
     * @uses BalanceLog::setValidFrom()
     * @uses BalanceLog::setValidTo()
     * @uses BalanceLog::setWalletType()
     * @param string $channel
     * @param string $commandDatetime
     * @param string $commandDescription
     * @param int $points
     * @param string $source
     * @param string $sourceDesc
     * @param string $validFrom
     * @param string $validTo
     * @param string $walletType
     */
    public function __construct($channel = null, $commandDatetime = null, $commandDescription = null, $points = null, $source = null, $sourceDesc = null, $validFrom = null, $validTo = null, $walletType = null)
    {
        $this
            ->setChannel($channel)
            ->setCommandDatetime($commandDatetime)
            ->setCommandDescription($commandDescription)
            ->setPoints($points)
            ->setSource($source)
            ->setSourceDesc($sourceDesc)
            ->setValidFrom($validFrom)
            ->setValidTo($validTo)
            ->setWalletType($walletType);
    }
    /**
     * Get Channel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChannel()
    {
        return isset($this->Channel) ? $this->Channel : null;
    }
    /**
     * Set Channel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $channel
     * @return \StructType\BalanceLog
     */
    public function setChannel($channel = null)
    {
        // validation for constraint: string
        if (!is_null($channel) && !is_string($channel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($channel, true), gettype($channel)), __LINE__);
        }
        if (is_null($channel) || (is_array($channel) && empty($channel))) {
            unset($this->Channel);
        } else {
            $this->Channel = $channel;
        }
        return $this;
    }
    /**
     * Get CommandDatetime value
     * @return string|null
     */
    public function getCommandDatetime()
    {
        return $this->CommandDatetime;
    }
    /**
     * Set CommandDatetime value
     * @param string $commandDatetime
     * @return \StructType\BalanceLog
     */
    public function setCommandDatetime($commandDatetime = null)
    {
        // validation for constraint: string
        if (!is_null($commandDatetime) && !is_string($commandDatetime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commandDatetime, true), gettype($commandDatetime)), __LINE__);
        }
        $this->CommandDatetime = $commandDatetime;
        return $this;
    }
    /**
     * Get CommandDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommandDescription()
    {
        return isset($this->CommandDescription) ? $this->CommandDescription : null;
    }
    /**
     * Set CommandDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commandDescription
     * @return \StructType\BalanceLog
     */
    public function setCommandDescription($commandDescription = null)
    {
        // validation for constraint: string
        if (!is_null($commandDescription) && !is_string($commandDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commandDescription, true), gettype($commandDescription)), __LINE__);
        }
        if (is_null($commandDescription) || (is_array($commandDescription) && empty($commandDescription))) {
            unset($this->CommandDescription);
        } else {
            $this->CommandDescription = $commandDescription;
        }
        return $this;
    }
    /**
     * Get Points value
     * @return int|null
     */
    public function getPoints()
    {
        return $this->Points;
    }
    /**
     * Set Points value
     * @param int $points
     * @return \StructType\BalanceLog
     */
    public function setPoints($points = null)
    {
        // validation for constraint: int
        if (!is_null($points) && !(is_int($points) || ctype_digit($points))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($points, true), gettype($points)), __LINE__);
        }
        $this->Points = $points;
        return $this;
    }
    /**
     * Get Source value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSource()
    {
        return isset($this->Source) ? $this->Source : null;
    }
    /**
     * Set Source value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $source
     * @return \StructType\BalanceLog
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source, true), gettype($source)), __LINE__);
        }
        if (is_null($source) || (is_array($source) && empty($source))) {
            unset($this->Source);
        } else {
            $this->Source = $source;
        }
        return $this;
    }
    /**
     * Get SourceDesc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceDesc()
    {
        return isset($this->SourceDesc) ? $this->SourceDesc : null;
    }
    /**
     * Set SourceDesc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sourceDesc
     * @return \StructType\BalanceLog
     */
    public function setSourceDesc($sourceDesc = null)
    {
        // validation for constraint: string
        if (!is_null($sourceDesc) && !is_string($sourceDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceDesc, true), gettype($sourceDesc)), __LINE__);
        }
        if (is_null($sourceDesc) || (is_array($sourceDesc) && empty($sourceDesc))) {
            unset($this->SourceDesc);
        } else {
            $this->SourceDesc = $sourceDesc;
        }
        return $this;
    }
    /**
     * Get ValidFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidFrom()
    {
        return isset($this->ValidFrom) ? $this->ValidFrom : null;
    }
    /**
     * Set ValidFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validFrom
     * @return \StructType\BalanceLog
     */
    public function setValidFrom($validFrom = null)
    {
        // validation for constraint: string
        if (!is_null($validFrom) && !is_string($validFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validFrom, true), gettype($validFrom)), __LINE__);
        }
        if (is_null($validFrom) || (is_array($validFrom) && empty($validFrom))) {
            unset($this->ValidFrom);
        } else {
            $this->ValidFrom = $validFrom;
        }
        return $this;
    }
    /**
     * Get ValidTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidTo()
    {
        return isset($this->ValidTo) ? $this->ValidTo : null;
    }
    /**
     * Set ValidTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validTo
     * @return \StructType\BalanceLog
     */
    public function setValidTo($validTo = null)
    {
        // validation for constraint: string
        if (!is_null($validTo) && !is_string($validTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validTo, true), gettype($validTo)), __LINE__);
        }
        if (is_null($validTo) || (is_array($validTo) && empty($validTo))) {
            unset($this->ValidTo);
        } else {
            $this->ValidTo = $validTo;
        }
        return $this;
    }
    /**
     * Get WalletType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWalletType()
    {
        return isset($this->WalletType) ? $this->WalletType : null;
    }
    /**
     * Set WalletType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $walletType
     * @return \StructType\BalanceLog
     */
    public function setWalletType($walletType = null)
    {
        // validation for constraint: string
        if (!is_null($walletType) && !is_string($walletType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($walletType, true), gettype($walletType)), __LINE__);
        }
        if (is_null($walletType) || (is_array($walletType) && empty($walletType))) {
            unset($this->WalletType);
        } else {
            $this->WalletType = $walletType;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BalanceLog
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
