<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Redeem ServiceType
 * @subpackage Services
 */
class Redeem extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RedeemItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RedeemItems $parameters
     * @return \StructType\RedeemItemsResponse|bool
     */
    public function RedeemItems(\StructType\RedeemItems $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RedeemItems($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RedeemItemsBeta
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RedeemItemsBeta $parameters
     * @return \StructType\RedeemItemsBetaResponse|bool
     */
    public function RedeemItemsBeta(\StructType\RedeemItemsBeta $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RedeemItemsBeta($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RedeemItemsBetaResponse|\StructType\RedeemItemsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
