<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Query ServiceType
 * @subpackage Services
 */
class Query extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named QueryAvailableItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\QueryAvailableItems $parameters
     * @return \StructType\QueryAvailableItemsResponse|bool
     */
    public function QueryAvailableItems(\StructType\QueryAvailableItems $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->QueryAvailableItems($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named QueryPoints
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\QueryPoints $parameters
     * @return \StructType\QueryPointsResponse|bool
     */
    public function QueryPoints(\StructType\QueryPoints $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->QueryPoints($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named QueryStockPoints
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\QueryStockPoints $parameters
     * @return \StructType\QueryStockPointsResponse|bool
     */
    public function QueryStockPoints(\StructType\QueryStockPoints $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->QueryStockPoints($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named QueryDefaultAvailableItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\QueryDefaultAvailableItems $parameters
     * @return \StructType\QueryDefaultAvailableItemsResponse|bool
     */
    public function QueryDefaultAvailableItems(\StructType\QueryDefaultAvailableItems $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->QueryDefaultAvailableItems($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\QueryAvailableItemsResponse|\StructType\QueryDefaultAvailableItemsResponse|\StructType\QueryPointsResponse|\StructType\QueryStockPointsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
