<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetMyWalletsWithPoints
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMyWalletsWithPoints $parameters
     * @return \StructType\GetMyWalletsWithPointsResponse|bool
     */
    public function GetMyWalletsWithPoints(\StructType\GetMyWalletsWithPoints $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMyWalletsWithPoints($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMyWalletsWithStockPoints
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMyWalletsWithStockPoints $parameters
     * @return \StructType\GetMyWalletsWithStockPointsResponse|bool
     */
    public function GetMyWalletsWithStockPoints(\StructType\GetMyWalletsWithStockPoints $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMyWalletsWithStockPoints($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCommandPrice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCommandPrice $parameters
     * @return \StructType\GetCommandPriceResponse|bool
     */
    public function GetCommandPrice(\StructType\GetCommandPrice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCommandPrice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCommandRestrictions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCommandRestrictions $parameters
     * @return \StructType\GetCommandRestrictionsResponse|bool
     */
    public function GetCommandRestrictions(\StructType\GetCommandRestrictions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCommandRestrictions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLineMembersWalletsCount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLineMembersWalletsCount $parameters
     * @return \StructType\GetLineMembersWalletsCountResponse|bool
     */
    public function GetLineMembersWalletsCount(\StructType\GetLineMembersWalletsCount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLineMembersWalletsCount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLineMembersPoints
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLineMembersPoints $parameters
     * @return \StructType\GetLineMembersPointsResponse|bool
     */
    public function GetLineMembersPoints(\StructType\GetLineMembersPoints $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLineMembersPoints($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAvailableWalletsForCommand
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAvailableWalletsForCommand $parameters
     * @return \StructType\GetAvailableWalletsForCommandResponse|bool
     */
    public function GetAvailableWalletsForCommand(\StructType\GetAvailableWalletsForCommand $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailableWalletsForCommand($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTransferDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTransferDetails $parameters
     * @return \StructType\GetTransferDetailsResponse|bool
     */
    public function GetTransferDetails(\StructType\GetTransferDetails $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTransferDetails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrdersSummary
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrdersSummary $parameters
     * @return \StructType\GetOrdersSummaryResponse|bool
     */
    public function GetOrdersSummary(\StructType\GetOrdersSummary $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOrdersSummary($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCataloguesSummary
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCataloguesSummary $parameters
     * @return \StructType\GetCataloguesSummaryResponse|bool
     */
    public function GetCataloguesSummary(\StructType\GetCataloguesSummary $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCataloguesSummary($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetAccountMembersWithRegistrationInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAccountMembersWithRegistrationInfo $parameters
     * @return \StructType\GetAccountMembersWithRegistrationInfoResponse|bool
     */
    public function GetAccountMembersWithRegistrationInfo(\StructType\GetAccountMembersWithRegistrationInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAccountMembersWithRegistrationInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLostPoints
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLostPoints $parameters
     * @return \StructType\GetLostPointsResponse|bool
     */
    public function GetLostPoints(\StructType\GetLostPoints $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLostPoints($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNextRedemptionDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNextRedemptionDate $parameters
     * @return \StructType\GetNextRedemptionDateResponse|bool
     */
    public function GetNextRedemptionDate(\StructType\GetNextRedemptionDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetNextRedemptionDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDeliveryChannels
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDeliveryChannels $parameters
     * @return \StructType\GetDeliveryChannelsResponse|bool
     */
    public function GetDeliveryChannels(\StructType\GetDeliveryChannels $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDeliveryChannels($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAvailableQuantity
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAvailableQuantity $parameters
     * @return \StructType\GetAvailableQuantityResponse|bool
     */
    public function GetAvailableQuantity(\StructType\GetAvailableQuantity $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailableQuantity($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDeliveryChannelTypes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDeliveryChannelTypes $parameters
     * @return \StructType\GetDeliveryChannelTypesResponse|bool
     */
    public function GetDeliveryChannelTypes(\StructType\GetDeliveryChannelTypes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDeliveryChannelTypes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAreas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAreas $parameters
     * @return \StructType\GetAreasResponse|bool
     */
    public function GetAreas(\StructType\GetAreas $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAreas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetArea
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetArea $parameters
     * @return \StructType\GetAreaResponse|bool
     */
    public function GetArea(\StructType\GetArea $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetArea($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAccountMembersWithRegistrationInfoResponse|\StructType\GetAreaResponse|\StructType\GetAreasResponse|\StructType\GetAvailableQuantityResponse|\StructType\GetAvailableWalletsForCommandResponse|\StructType\GetCataloguesSummaryResponse|\StructType\GetCommandPriceResponse|\StructType\GetCommandRestrictionsResponse|\StructType\GetDeliveryChannelsResponse|\StructType\GetDeliveryChannelTypesResponse|\StructType\GetLineMembersPointsResponse|\StructType\GetLineMembersWalletsCountResponse|\StructType\GetLostPointsResponse|\StructType\GetMyWalletsWithPointsResponse|\StructType\GetMyWalletsWithStockPointsResponse|\StructType\GetNextRedemptionDateResponse|\StructType\GetOrdersSummaryResponse|\StructType\GetTransferDetailsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
