<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Balance ServiceType
 * @subpackage Services
 */
class Balance extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named BalanceHistory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\BalanceHistory $parameters
     * @return \StructType\BalanceHistoryResponse|bool
     */
    public function BalanceHistory(\StructType\BalanceHistory $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->BalanceHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\BalanceHistoryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
