<?php

namespace EnumType;

/**
 * This class stands for ParamType EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ParamType
 * @subpackage Enumerations
 */
class ParamType
{
    /**
     * Constant for value 'ContractNumber'
     * @return string 'ContractNumber'
     */
    const VALUE_CONTRACT_NUMBER = 'ContractNumber';
    /**
     * Constant for value 'Msisdn'
     * @return string 'Msisdn'
     */
    const VALUE_MSISDN = 'Msisdn';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CONTRACT_NUMBER
     * @uses self::VALUE_MSISDN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CONTRACT_NUMBER,
            self::VALUE_MSISDN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
