<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRedeemableItemCategory ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfRedeemableItemCategory
 * @subpackage Arrays
 */
class ArrayOfRedeemableItemCategory extends AbstractStructArrayBase
{
    /**
     * The RedeemableItemCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RedeemableItemCategory[]
     */
    public $RedeemableItemCategory;
    /**
     * Constructor method for ArrayOfRedeemableItemCategory
     * @uses ArrayOfRedeemableItemCategory::setRedeemableItemCategory()
     * @param \StructType\RedeemableItemCategory[] $redeemableItemCategory
     */
    public function __construct(array $redeemableItemCategory = array())
    {
        $this
            ->setRedeemableItemCategory($redeemableItemCategory);
    }
    /**
     * Get RedeemableItemCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RedeemableItemCategory[]|null
     */
    public function getRedeemableItemCategory()
    {
        return isset($this->RedeemableItemCategory) ? $this->RedeemableItemCategory : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRedeemableItemCategory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRedeemableItemCategory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRedeemableItemCategoryForArrayConstraintsFromSetRedeemableItemCategory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfRedeemableItemCategoryRedeemableItemCategoryItem) {
            // validation for constraint: itemType
            if (!$arrayOfRedeemableItemCategoryRedeemableItemCategoryItem instanceof \StructType\RedeemableItemCategory) {
                $invalidValues[] = is_object($arrayOfRedeemableItemCategoryRedeemableItemCategoryItem) ? get_class($arrayOfRedeemableItemCategoryRedeemableItemCategoryItem) : sprintf('%s(%s)', gettype($arrayOfRedeemableItemCategoryRedeemableItemCategoryItem), var_export($arrayOfRedeemableItemCategoryRedeemableItemCategoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RedeemableItemCategory property can only contain items of type \StructType\RedeemableItemCategory, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RedeemableItemCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RedeemableItemCategory[] $redeemableItemCategory
     * @return \ArrayType\ArrayOfRedeemableItemCategory
     */
    public function setRedeemableItemCategory(array $redeemableItemCategory = array())
    {
        // validation for constraint: array
        if ('' !== ($redeemableItemCategoryArrayErrorMessage = self::validateRedeemableItemCategoryForArrayConstraintsFromSetRedeemableItemCategory($redeemableItemCategory))) {
            throw new \InvalidArgumentException($redeemableItemCategoryArrayErrorMessage, __LINE__);
        }
        if (is_null($redeemableItemCategory) || (is_array($redeemableItemCategory) && empty($redeemableItemCategory))) {
            unset($this->RedeemableItemCategory);
        } else {
            $this->RedeemableItemCategory = $redeemableItemCategory;
        }
        return $this;
    }
    /**
     * Add item to RedeemableItemCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\RedeemableItemCategory $item
     * @return \ArrayType\ArrayOfRedeemableItemCategory
     */
    public function addToRedeemableItemCategory(\StructType\RedeemableItemCategory $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RedeemableItemCategory) {
            throw new \InvalidArgumentException(sprintf('The RedeemableItemCategory property can only contain items of type \StructType\RedeemableItemCategory, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RedeemableItemCategory[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\RedeemableItemCategory|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\RedeemableItemCategory|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\RedeemableItemCategory|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\RedeemableItemCategory|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\RedeemableItemCategory|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RedeemableItemCategory
     */
    public function getAttributeName()
    {
        return 'RedeemableItemCategory';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfRedeemableItemCategory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
