<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Query ServiceType
 */
$query = new \ServiceType\Query($options);
/**
 * Sample call for QueryAvailableItems operation/method
 */
if ($query->QueryAvailableItems(new \StructType\QueryAvailableItems()) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for QueryPoints operation/method
 */
if ($query->QueryPoints(new \StructType\QueryPoints()) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for QueryStockPoints operation/method
 */
if ($query->QueryStockPoints(new \StructType\QueryStockPoints()) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for QueryDefaultAvailableItems operation/method
 */
if ($query->QueryDefaultAvailableItems(new \StructType\QueryDefaultAvailableItems()) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetMyWalletsWithPoints operation/method
 */
if ($get->GetMyWalletsWithPoints(new \StructType\GetMyWalletsWithPoints()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMyWalletsWithStockPoints operation/method
 */
if ($get->GetMyWalletsWithStockPoints(new \StructType\GetMyWalletsWithStockPoints()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCommandPrice operation/method
 */
if ($get->GetCommandPrice(new \StructType\GetCommandPrice()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCommandRestrictions operation/method
 */
if ($get->GetCommandRestrictions(new \StructType\GetCommandRestrictions()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLineMembersWalletsCount operation/method
 */
if ($get->GetLineMembersWalletsCount(new \StructType\GetLineMembersWalletsCount()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLineMembersPoints operation/method
 */
if ($get->GetLineMembersPoints(new \StructType\GetLineMembersPoints()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAvailableWalletsForCommand operation/method
 */
if ($get->GetAvailableWalletsForCommand(new \StructType\GetAvailableWalletsForCommand()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTransferDetails operation/method
 */
if ($get->GetTransferDetails(new \StructType\GetTransferDetails()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetOrdersSummary operation/method
 */
if ($get->GetOrdersSummary(new \StructType\GetOrdersSummary()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCataloguesSummary operation/method
 */
if ($get->GetCataloguesSummary(new \StructType\GetCataloguesSummary()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAccountMembersWithRegistrationInfo operation/method
 */
if ($get->GetAccountMembersWithRegistrationInfo(new \StructType\GetAccountMembersWithRegistrationInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLostPoints operation/method
 */
if ($get->GetLostPoints(new \StructType\GetLostPoints()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetNextRedemptionDate operation/method
 */
if ($get->GetNextRedemptionDate(new \StructType\GetNextRedemptionDate()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDeliveryChannels operation/method
 */
if ($get->GetDeliveryChannels(new \StructType\GetDeliveryChannels()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAvailableQuantity operation/method
 */
if ($get->GetAvailableQuantity(new \StructType\GetAvailableQuantity()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDeliveryChannelTypes operation/method
 */
if ($get->GetDeliveryChannelTypes(new \StructType\GetDeliveryChannelTypes()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAreas operation/method
 */
if ($get->GetAreas(new \StructType\GetAreas()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetArea operation/method
 */
if ($get->GetArea(new \StructType\GetArea()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Is ServiceType
 */
$is = new \ServiceType\Is($options);
/**
 * Sample call for IsCustomerRegistered operation/method
 */
if ($is->IsCustomerRegistered(new \StructType\IsCustomerRegistered()) !== false) {
    print_r($is->getResult());
} else {
    print_r($is->getLastError());
}
/**
 * Samples for Redemption ServiceType
 */
$redemption = new \ServiceType\Redemption($options);
/**
 * Sample call for RedemptionHistory operation/method
 */
if ($redemption->RedemptionHistory(new \StructType\RedemptionHistory()) !== false) {
    print_r($redemption->getResult());
} else {
    print_r($redemption->getLastError());
}
/**
 * Samples for Give ServiceType
 */
$give = new \ServiceType\Give($options);
/**
 * Sample call for GivePoints operation/method
 */
if ($give->GivePoints(new \StructType\GivePoints()) !== false) {
    print_r($give->getResult());
} else {
    print_r($give->getLastError());
}
/**
 * Samples for Take ServiceType
 */
$take = new \ServiceType\Take($options);
/**
 * Sample call for TakePoints operation/method
 */
if ($take->TakePoints(new \StructType\TakePoints()) !== false) {
    print_r($take->getResult());
} else {
    print_r($take->getLastError());
}
/**
 * Samples for Buy ServiceType
 */
$buy = new \ServiceType\Buy($options);
/**
 * Sample call for BuyPoints operation/method
 */
if ($buy->BuyPoints(new \StructType\BuyPoints()) !== false) {
    print_r($buy->getResult());
} else {
    print_r($buy->getLastError());
}
/**
 * Samples for Redeem ServiceType
 */
$redeem = new \ServiceType\Redeem($options);
/**
 * Sample call for RedeemItems operation/method
 */
if ($redeem->RedeemItems(new \StructType\RedeemItems()) !== false) {
    print_r($redeem->getResult());
} else {
    print_r($redeem->getLastError());
}
/**
 * Sample call for RedeemItemsBeta operation/method
 */
if ($redeem->RedeemItemsBeta(new \StructType\RedeemItemsBeta()) !== false) {
    print_r($redeem->getResult());
} else {
    print_r($redeem->getLastError());
}
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \ServiceType\Cancel($options);
/**
 * Sample call for CancelRedeem operation/method
 */
if ($cancel->CancelRedeem(new \StructType\CancelRedeem()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Samples for Deliver ServiceType
 */
$deliver = new \ServiceType\Deliver($options);
/**
 * Sample call for DeliverItems operation/method
 */
if ($deliver->DeliverItems(new \StructType\DeliverItems()) !== false) {
    print_r($deliver->getResult());
} else {
    print_r($deliver->getLastError());
}
/**
 * Samples for Un ServiceType
 */
$un = new \ServiceType\Un($options);
/**
 * Sample call for UnRegister operation/method
 */
if ($un->UnRegister(new \StructType\UnRegister()) !== false) {
    print_r($un->getResult());
} else {
    print_r($un->getLastError());
}
/**
 * Samples for Register ServiceType
 */
$register = new \ServiceType\Register($options);
/**
 * Sample call for Register operation/method
 */
if ($register->Register(new \StructType\Register()) !== false) {
    print_r($register->getResult());
} else {
    print_r($register->getLastError());
}
/**
 * Samples for Redeemable ServiceType
 */
$redeemable = new \ServiceType\Redeemable($options);
/**
 * Sample call for RedeemableItemDetails operation/method
 */
if ($redeemable->RedeemableItemDetails(new \StructType\RedeemableItemDetails()) !== false) {
    print_r($redeemable->getResult());
} else {
    print_r($redeemable->getLastError());
}
/**
 * Samples for Enable ServiceType
 */
$enable = new \ServiceType\Enable($options);
/**
 * Sample call for EnableCustomer operation/method
 */
if ($enable->EnableCustomer(new \StructType\EnableCustomer()) !== false) {
    print_r($enable->getResult());
} else {
    print_r($enable->getLastError());
}
/**
 * Samples for Disable ServiceType
 */
$disable = new \ServiceType\Disable($options);
/**
 * Sample call for DisableCustomer operation/method
 */
if ($disable->DisableCustomer(new \StructType\DisableCustomer()) !== false) {
    print_r($disable->getResult());
} else {
    print_r($disable->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
/**
 * Sample call for AddPoints operation/method
 */
if ($add->AddPoints(new \StructType\AddPoints()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Remove ServiceType
 */
$remove = new \ServiceType\Remove($options);
/**
 * Sample call for RemovePoints operation/method
 */
if ($remove->RemovePoints(new \StructType\RemovePoints()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Samples for Balance ServiceType
 */
$balance = new \ServiceType\Balance($options);
/**
 * Sample call for BalanceHistory operation/method
 */
if ($balance->BalanceHistory(new \StructType\BalanceHistory()) !== false) {
    print_r($balance->getResult());
} else {
    print_r($balance->getLastError());
}
/**
 * Samples for Password ServiceType
 */
$password = new \ServiceType\Password($options);
/**
 * Sample call for PasswordRequest operation/method
 */
if ($password->PasswordRequest(new \StructType\PasswordRequest()) !== false) {
    print_r($password->getResult());
} else {
    print_r($password->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \ServiceType\Send($options);
/**
 * Sample call for SendEmailLink operation/method
 */
if ($send->SendEmailLink(new \StructType\SendEmailLink()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Samples for Change ServiceType
 */
$change = new \ServiceType\Change($options);
/**
 * Sample call for ChangePassword operation/method
 */
if ($change->ChangePassword(new \StructType\ChangePassword()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
