<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Wallet StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Wallet
 * @subpackage Structs
 */
class Wallet extends AbstractStructBase
{
    /**
     * The Points
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Points;
    /**
     * The StockPoints
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfStock
     */
    public $StockPoints;
    /**
     * The WalletType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WalletType
     */
    public $WalletType;
    /**
     * Constructor method for Wallet
     * @uses Wallet::setPoints()
     * @uses Wallet::setStockPoints()
     * @uses Wallet::setWalletType()
     * @param int $points
     * @param \ArrayType\ArrayOfStock $stockPoints
     * @param \StructType\WalletType $walletType
     */
    public function __construct($points = null, \ArrayType\ArrayOfStock $stockPoints = null, \StructType\WalletType $walletType = null)
    {
        $this
            ->setPoints($points)
            ->setStockPoints($stockPoints)
            ->setWalletType($walletType);
    }
    /**
     * Get Points value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPoints()
    {
        return isset($this->Points) ? $this->Points : null;
    }
    /**
     * Set Points value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $points
     * @return \StructType\Wallet
     */
    public function setPoints($points = null)
    {
        // validation for constraint: int
        if (!is_null($points) && !(is_int($points) || ctype_digit($points))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($points, true), gettype($points)), __LINE__);
        }
        if (is_null($points) || (is_array($points) && empty($points))) {
            unset($this->Points);
        } else {
            $this->Points = $points;
        }
        return $this;
    }
    /**
     * Get StockPoints value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfStock|null
     */
    public function getStockPoints()
    {
        return isset($this->StockPoints) ? $this->StockPoints : null;
    }
    /**
     * Set StockPoints value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfStock $stockPoints
     * @return \StructType\Wallet
     */
    public function setStockPoints(\ArrayType\ArrayOfStock $stockPoints = null)
    {
        if (is_null($stockPoints) || (is_array($stockPoints) && empty($stockPoints))) {
            unset($this->StockPoints);
        } else {
            $this->StockPoints = $stockPoints;
        }
        return $this;
    }
    /**
     * Get WalletType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WalletType|null
     */
    public function getWalletType()
    {
        return isset($this->WalletType) ? $this->WalletType : null;
    }
    /**
     * Set WalletType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WalletType $walletType
     * @return \StructType\Wallet
     */
    public function setWalletType(\StructType\WalletType $walletType = null)
    {
        if (is_null($walletType) || (is_array($walletType) && empty($walletType))) {
            unset($this->WalletType);
        } else {
            $this->WalletType = $walletType;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Wallet
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
