<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendEmailLink StructType
 * @subpackage Structs
 */
class SendEmailLink extends AbstractStructBase
{
    /**
     * The loginName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $loginName;
    /**
     * The emailLink
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $emailLink;
    /**
     * The language
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $language;
    /**
     * Constructor method for SendEmailLink
     * @uses SendEmailLink::setLoginName()
     * @uses SendEmailLink::setEmailLink()
     * @uses SendEmailLink::setLanguage()
     * @param string $loginName
     * @param string $emailLink
     * @param string $language
     */
    public function __construct($loginName = null, $emailLink = null, $language = null)
    {
        $this
            ->setLoginName($loginName)
            ->setEmailLink($emailLink)
            ->setLanguage($language);
    }
    /**
     * Get loginName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoginName()
    {
        return isset($this->loginName) ? $this->loginName : null;
    }
    /**
     * Set loginName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loginName
     * @return \StructType\SendEmailLink
     */
    public function setLoginName($loginName = null)
    {
        // validation for constraint: string
        if (!is_null($loginName) && !is_string($loginName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginName, true), gettype($loginName)), __LINE__);
        }
        if (is_null($loginName) || (is_array($loginName) && empty($loginName))) {
            unset($this->loginName);
        } else {
            $this->loginName = $loginName;
        }
        return $this;
    }
    /**
     * Get emailLink value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailLink()
    {
        return isset($this->emailLink) ? $this->emailLink : null;
    }
    /**
     * Set emailLink value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailLink
     * @return \StructType\SendEmailLink
     */
    public function setEmailLink($emailLink = null)
    {
        // validation for constraint: string
        if (!is_null($emailLink) && !is_string($emailLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailLink, true), gettype($emailLink)), __LINE__);
        }
        if (is_null($emailLink) || (is_array($emailLink) && empty($emailLink))) {
            unset($this->emailLink);
        } else {
            $this->emailLink = $emailLink;
        }
        return $this;
    }
    /**
     * Get language value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLanguage()
    {
        return isset($this->language) ? $this->language : null;
    }
    /**
     * Set language value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $language
     * @return \StructType\SendEmailLink
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        if (is_null($language) || (is_array($language) && empty($language))) {
            unset($this->language);
        } else {
            $this->language = $language;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SendEmailLink
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
