<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RedemptionItemsLog StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RedemptionItemsLog
 * @subpackage Structs
 */
class RedemptionItemsLog extends AbstractStructBase
{
    /**
     * The Cancelled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Cancelled;
    /**
     * The Command
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Command
     */
    public $Command;
    /**
     * The CommandDateKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CommandDateKey;
    /**
     * The CommandDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CommandDateTime;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CustomerId;
    /**
     * The DeliveryChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DeliveryChannel
     */
    public $DeliveryChannel;
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Error
     */
    public $Error;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The NumberOfunits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfunits;
    /**
     * The PhysicalItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $PhysicalItem;
    /**
     * The PointsLogs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfRedemptionItemPointsLog
     */
    public $PointsLogs;
    /**
     * The PricePointsPerUnit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PricePointsPerUnit;
    /**
     * The PriceProvisioningAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PriceProvisioningAmount;
    /**
     * The PriceProvisioningPlatformCodeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PriceProvisioningPlatformCodeId;
    /**
     * The ProvisioningPlatformCodeDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProvisioningPlatformCodeDescription;
    /**
     * The ProvisioningTransactionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ProvisioningTransactionId;
    /**
     * The Reason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CommandReason
     */
    public $Reason;
    /**
     * The RedeemableItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RedeemableItem
     */
    public $RedeemableItem;
    /**
     * The RedeemableItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RedeemableItemId;
    /**
     * The RedemptionLogId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RedemptionLogId;
    /**
     * The WalletType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WalletType
     */
    public $WalletType;
    /**
     * Constructor method for RedemptionItemsLog
     * @uses RedemptionItemsLog::setCancelled()
     * @uses RedemptionItemsLog::setCommand()
     * @uses RedemptionItemsLog::setCommandDateKey()
     * @uses RedemptionItemsLog::setCommandDateTime()
     * @uses RedemptionItemsLog::setCustomerId()
     * @uses RedemptionItemsLog::setDeliveryChannel()
     * @uses RedemptionItemsLog::setError()
     * @uses RedemptionItemsLog::setId()
     * @uses RedemptionItemsLog::setNumberOfunits()
     * @uses RedemptionItemsLog::setPhysicalItem()
     * @uses RedemptionItemsLog::setPointsLogs()
     * @uses RedemptionItemsLog::setPricePointsPerUnit()
     * @uses RedemptionItemsLog::setPriceProvisioningAmount()
     * @uses RedemptionItemsLog::setPriceProvisioningPlatformCodeId()
     * @uses RedemptionItemsLog::setProvisioningPlatformCodeDescription()
     * @uses RedemptionItemsLog::setProvisioningTransactionId()
     * @uses RedemptionItemsLog::setReason()
     * @uses RedemptionItemsLog::setRedeemableItem()
     * @uses RedemptionItemsLog::setRedeemableItemId()
     * @uses RedemptionItemsLog::setRedemptionLogId()
     * @uses RedemptionItemsLog::setWalletType()
     * @param bool $cancelled
     * @param \StructType\Command $command
     * @param string $commandDateKey
     * @param string $commandDateTime
     * @param int $customerId
     * @param \StructType\DeliveryChannel $deliveryChannel
     * @param \StructType\Error $error
     * @param int $id
     * @param int $numberOfunits
     * @param bool $physicalItem
     * @param \ArrayType\ArrayOfRedemptionItemPointsLog $pointsLogs
     * @param int $pricePointsPerUnit
     * @param float $priceProvisioningAmount
     * @param int $priceProvisioningPlatformCodeId
     * @param string $provisioningPlatformCodeDescription
     * @param int $provisioningTransactionId
     * @param \StructType\CommandReason $reason
     * @param \StructType\RedeemableItem $redeemableItem
     * @param int $redeemableItemId
     * @param int $redemptionLogId
     * @param \StructType\WalletType $walletType
     */
    public function __construct($cancelled = null, \StructType\Command $command = null, $commandDateKey = null, $commandDateTime = null, $customerId = null, \StructType\DeliveryChannel $deliveryChannel = null, \StructType\Error $error = null, $id = null, $numberOfunits = null, $physicalItem = null, \ArrayType\ArrayOfRedemptionItemPointsLog $pointsLogs = null, $pricePointsPerUnit = null, $priceProvisioningAmount = null, $priceProvisioningPlatformCodeId = null, $provisioningPlatformCodeDescription = null, $provisioningTransactionId = null, \StructType\CommandReason $reason = null, \StructType\RedeemableItem $redeemableItem = null, $redeemableItemId = null, $redemptionLogId = null, \StructType\WalletType $walletType = null)
    {
        $this
            ->setCancelled($cancelled)
            ->setCommand($command)
            ->setCommandDateKey($commandDateKey)
            ->setCommandDateTime($commandDateTime)
            ->setCustomerId($customerId)
            ->setDeliveryChannel($deliveryChannel)
            ->setError($error)
            ->setId($id)
            ->setNumberOfunits($numberOfunits)
            ->setPhysicalItem($physicalItem)
            ->setPointsLogs($pointsLogs)
            ->setPricePointsPerUnit($pricePointsPerUnit)
            ->setPriceProvisioningAmount($priceProvisioningAmount)
            ->setPriceProvisioningPlatformCodeId($priceProvisioningPlatformCodeId)
            ->setProvisioningPlatformCodeDescription($provisioningPlatformCodeDescription)
            ->setProvisioningTransactionId($provisioningTransactionId)
            ->setReason($reason)
            ->setRedeemableItem($redeemableItem)
            ->setRedeemableItemId($redeemableItemId)
            ->setRedemptionLogId($redemptionLogId)
            ->setWalletType($walletType);
    }
    /**
     * Get Cancelled value
     * @return bool|null
     */
    public function getCancelled()
    {
        return $this->Cancelled;
    }
    /**
     * Set Cancelled value
     * @param bool $cancelled
     * @return \StructType\RedemptionItemsLog
     */
    public function setCancelled($cancelled = null)
    {
        // validation for constraint: boolean
        if (!is_null($cancelled) && !is_bool($cancelled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cancelled, true), gettype($cancelled)), __LINE__);
        }
        $this->Cancelled = $cancelled;
        return $this;
    }
    /**
     * Get Command value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Command|null
     */
    public function getCommand()
    {
        return isset($this->Command) ? $this->Command : null;
    }
    /**
     * Set Command value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Command $command
     * @return \StructType\RedemptionItemsLog
     */
    public function setCommand(\StructType\Command $command = null)
    {
        if (is_null($command) || (is_array($command) && empty($command))) {
            unset($this->Command);
        } else {
            $this->Command = $command;
        }
        return $this;
    }
    /**
     * Get CommandDateKey value
     * @return string|null
     */
    public function getCommandDateKey()
    {
        return $this->CommandDateKey;
    }
    /**
     * Set CommandDateKey value
     * @param string $commandDateKey
     * @return \StructType\RedemptionItemsLog
     */
    public function setCommandDateKey($commandDateKey = null)
    {
        // validation for constraint: string
        if (!is_null($commandDateKey) && !is_string($commandDateKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commandDateKey, true), gettype($commandDateKey)), __LINE__);
        }
        $this->CommandDateKey = $commandDateKey;
        return $this;
    }
    /**
     * Get CommandDateTime value
     * @return string|null
     */
    public function getCommandDateTime()
    {
        return $this->CommandDateTime;
    }
    /**
     * Set CommandDateTime value
     * @param string $commandDateTime
     * @return \StructType\RedemptionItemsLog
     */
    public function setCommandDateTime($commandDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($commandDateTime) && !is_string($commandDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commandDateTime, true), gettype($commandDateTime)), __LINE__);
        }
        $this->CommandDateTime = $commandDateTime;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return int|null
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \StructType\RedemptionItemsLog
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get DeliveryChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DeliveryChannel|null
     */
    public function getDeliveryChannel()
    {
        return isset($this->DeliveryChannel) ? $this->DeliveryChannel : null;
    }
    /**
     * Set DeliveryChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DeliveryChannel $deliveryChannel
     * @return \StructType\RedemptionItemsLog
     */
    public function setDeliveryChannel(\StructType\DeliveryChannel $deliveryChannel = null)
    {
        if (is_null($deliveryChannel) || (is_array($deliveryChannel) && empty($deliveryChannel))) {
            unset($this->DeliveryChannel);
        } else {
            $this->DeliveryChannel = $deliveryChannel;
        }
        return $this;
    }
    /**
     * Get Error value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Error|null
     */
    public function getError()
    {
        return isset($this->Error) ? $this->Error : null;
    }
    /**
     * Set Error value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Error $error
     * @return \StructType\RedemptionItemsLog
     */
    public function setError(\StructType\Error $error = null)
    {
        if (is_null($error) || (is_array($error) && empty($error))) {
            unset($this->Error);
        } else {
            $this->Error = $error;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\RedemptionItemsLog
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get NumberOfunits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfunits()
    {
        return isset($this->NumberOfunits) ? $this->NumberOfunits : null;
    }
    /**
     * Set NumberOfunits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfunits
     * @return \StructType\RedemptionItemsLog
     */
    public function setNumberOfunits($numberOfunits = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfunits) && !(is_int($numberOfunits) || ctype_digit($numberOfunits))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfunits, true), gettype($numberOfunits)), __LINE__);
        }
        if (is_null($numberOfunits) || (is_array($numberOfunits) && empty($numberOfunits))) {
            unset($this->NumberOfunits);
        } else {
            $this->NumberOfunits = $numberOfunits;
        }
        return $this;
    }
    /**
     * Get PhysicalItem value
     * @return bool|null
     */
    public function getPhysicalItem()
    {
        return $this->PhysicalItem;
    }
    /**
     * Set PhysicalItem value
     * @param bool $physicalItem
     * @return \StructType\RedemptionItemsLog
     */
    public function setPhysicalItem($physicalItem = null)
    {
        // validation for constraint: boolean
        if (!is_null($physicalItem) && !is_bool($physicalItem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($physicalItem, true), gettype($physicalItem)), __LINE__);
        }
        $this->PhysicalItem = $physicalItem;
        return $this;
    }
    /**
     * Get PointsLogs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfRedemptionItemPointsLog|null
     */
    public function getPointsLogs()
    {
        return isset($this->PointsLogs) ? $this->PointsLogs : null;
    }
    /**
     * Set PointsLogs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfRedemptionItemPointsLog $pointsLogs
     * @return \StructType\RedemptionItemsLog
     */
    public function setPointsLogs(\ArrayType\ArrayOfRedemptionItemPointsLog $pointsLogs = null)
    {
        if (is_null($pointsLogs) || (is_array($pointsLogs) && empty($pointsLogs))) {
            unset($this->PointsLogs);
        } else {
            $this->PointsLogs = $pointsLogs;
        }
        return $this;
    }
    /**
     * Get PricePointsPerUnit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPricePointsPerUnit()
    {
        return isset($this->PricePointsPerUnit) ? $this->PricePointsPerUnit : null;
    }
    /**
     * Set PricePointsPerUnit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pricePointsPerUnit
     * @return \StructType\RedemptionItemsLog
     */
    public function setPricePointsPerUnit($pricePointsPerUnit = null)
    {
        // validation for constraint: int
        if (!is_null($pricePointsPerUnit) && !(is_int($pricePointsPerUnit) || ctype_digit($pricePointsPerUnit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pricePointsPerUnit, true), gettype($pricePointsPerUnit)), __LINE__);
        }
        if (is_null($pricePointsPerUnit) || (is_array($pricePointsPerUnit) && empty($pricePointsPerUnit))) {
            unset($this->PricePointsPerUnit);
        } else {
            $this->PricePointsPerUnit = $pricePointsPerUnit;
        }
        return $this;
    }
    /**
     * Get PriceProvisioningAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPriceProvisioningAmount()
    {
        return isset($this->PriceProvisioningAmount) ? $this->PriceProvisioningAmount : null;
    }
    /**
     * Set PriceProvisioningAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $priceProvisioningAmount
     * @return \StructType\RedemptionItemsLog
     */
    public function setPriceProvisioningAmount($priceProvisioningAmount = null)
    {
        // validation for constraint: float
        if (!is_null($priceProvisioningAmount) && !(is_float($priceProvisioningAmount) || is_numeric($priceProvisioningAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($priceProvisioningAmount, true), gettype($priceProvisioningAmount)), __LINE__);
        }
        if (is_null($priceProvisioningAmount) || (is_array($priceProvisioningAmount) && empty($priceProvisioningAmount))) {
            unset($this->PriceProvisioningAmount);
        } else {
            $this->PriceProvisioningAmount = $priceProvisioningAmount;
        }
        return $this;
    }
    /**
     * Get PriceProvisioningPlatformCodeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriceProvisioningPlatformCodeId()
    {
        return isset($this->PriceProvisioningPlatformCodeId) ? $this->PriceProvisioningPlatformCodeId : null;
    }
    /**
     * Set PriceProvisioningPlatformCodeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priceProvisioningPlatformCodeId
     * @return \StructType\RedemptionItemsLog
     */
    public function setPriceProvisioningPlatformCodeId($priceProvisioningPlatformCodeId = null)
    {
        // validation for constraint: int
        if (!is_null($priceProvisioningPlatformCodeId) && !(is_int($priceProvisioningPlatformCodeId) || ctype_digit($priceProvisioningPlatformCodeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priceProvisioningPlatformCodeId, true), gettype($priceProvisioningPlatformCodeId)), __LINE__);
        }
        if (is_null($priceProvisioningPlatformCodeId) || (is_array($priceProvisioningPlatformCodeId) && empty($priceProvisioningPlatformCodeId))) {
            unset($this->PriceProvisioningPlatformCodeId);
        } else {
            $this->PriceProvisioningPlatformCodeId = $priceProvisioningPlatformCodeId;
        }
        return $this;
    }
    /**
     * Get ProvisioningPlatformCodeDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProvisioningPlatformCodeDescription()
    {
        return isset($this->ProvisioningPlatformCodeDescription) ? $this->ProvisioningPlatformCodeDescription : null;
    }
    /**
     * Set ProvisioningPlatformCodeDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $provisioningPlatformCodeDescription
     * @return \StructType\RedemptionItemsLog
     */
    public function setProvisioningPlatformCodeDescription($provisioningPlatformCodeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($provisioningPlatformCodeDescription) && !is_string($provisioningPlatformCodeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provisioningPlatformCodeDescription, true), gettype($provisioningPlatformCodeDescription)), __LINE__);
        }
        if (is_null($provisioningPlatformCodeDescription) || (is_array($provisioningPlatformCodeDescription) && empty($provisioningPlatformCodeDescription))) {
            unset($this->ProvisioningPlatformCodeDescription);
        } else {
            $this->ProvisioningPlatformCodeDescription = $provisioningPlatformCodeDescription;
        }
        return $this;
    }
    /**
     * Get ProvisioningTransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getProvisioningTransactionId()
    {
        return isset($this->ProvisioningTransactionId) ? $this->ProvisioningTransactionId : null;
    }
    /**
     * Set ProvisioningTransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $provisioningTransactionId
     * @return \StructType\RedemptionItemsLog
     */
    public function setProvisioningTransactionId($provisioningTransactionId = null)
    {
        // validation for constraint: int
        if (!is_null($provisioningTransactionId) && !(is_int($provisioningTransactionId) || ctype_digit($provisioningTransactionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($provisioningTransactionId, true), gettype($provisioningTransactionId)), __LINE__);
        }
        if (is_null($provisioningTransactionId) || (is_array($provisioningTransactionId) && empty($provisioningTransactionId))) {
            unset($this->ProvisioningTransactionId);
        } else {
            $this->ProvisioningTransactionId = $provisioningTransactionId;
        }
        return $this;
    }
    /**
     * Get Reason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CommandReason|null
     */
    public function getReason()
    {
        return isset($this->Reason) ? $this->Reason : null;
    }
    /**
     * Set Reason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CommandReason $reason
     * @return \StructType\RedemptionItemsLog
     */
    public function setReason(\StructType\CommandReason $reason = null)
    {
        if (is_null($reason) || (is_array($reason) && empty($reason))) {
            unset($this->Reason);
        } else {
            $this->Reason = $reason;
        }
        return $this;
    }
    /**
     * Get RedeemableItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RedeemableItem|null
     */
    public function getRedeemableItem()
    {
        return isset($this->RedeemableItem) ? $this->RedeemableItem : null;
    }
    /**
     * Set RedeemableItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RedeemableItem $redeemableItem
     * @return \StructType\RedemptionItemsLog
     */
    public function setRedeemableItem(\StructType\RedeemableItem $redeemableItem = null)
    {
        if (is_null($redeemableItem) || (is_array($redeemableItem) && empty($redeemableItem))) {
            unset($this->RedeemableItem);
        } else {
            $this->RedeemableItem = $redeemableItem;
        }
        return $this;
    }
    /**
     * Get RedeemableItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRedeemableItemId()
    {
        return isset($this->RedeemableItemId) ? $this->RedeemableItemId : null;
    }
    /**
     * Set RedeemableItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $redeemableItemId
     * @return \StructType\RedemptionItemsLog
     */
    public function setRedeemableItemId($redeemableItemId = null)
    {
        // validation for constraint: int
        if (!is_null($redeemableItemId) && !(is_int($redeemableItemId) || ctype_digit($redeemableItemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($redeemableItemId, true), gettype($redeemableItemId)), __LINE__);
        }
        if (is_null($redeemableItemId) || (is_array($redeemableItemId) && empty($redeemableItemId))) {
            unset($this->RedeemableItemId);
        } else {
            $this->RedeemableItemId = $redeemableItemId;
        }
        return $this;
    }
    /**
     * Get RedemptionLogId value
     * @return int|null
     */
    public function getRedemptionLogId()
    {
        return $this->RedemptionLogId;
    }
    /**
     * Set RedemptionLogId value
     * @param int $redemptionLogId
     * @return \StructType\RedemptionItemsLog
     */
    public function setRedemptionLogId($redemptionLogId = null)
    {
        // validation for constraint: int
        if (!is_null($redemptionLogId) && !(is_int($redemptionLogId) || ctype_digit($redemptionLogId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($redemptionLogId, true), gettype($redemptionLogId)), __LINE__);
        }
        $this->RedemptionLogId = $redemptionLogId;
        return $this;
    }
    /**
     * Get WalletType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WalletType|null
     */
    public function getWalletType()
    {
        return isset($this->WalletType) ? $this->WalletType : null;
    }
    /**
     * Set WalletType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WalletType $walletType
     * @return \StructType\RedemptionItemsLog
     */
    public function setWalletType(\StructType\WalletType $walletType = null)
    {
        if (is_null($walletType) || (is_array($walletType) && empty($walletType))) {
            unset($this->WalletType);
        } else {
            $this->WalletType = $walletType;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RedemptionItemsLog
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
