<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RedeemableItemsResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RedeemableItemsResponse
 * @subpackage Structs
 */
class RedeemableItemsResponse extends ApiResponse
{
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfRedeemableItem
     */
    public $Items;
    /**
     * Constructor method for RedeemableItemsResponse
     * @uses RedeemableItemsResponse::setItems()
     * @param \ArrayType\ArrayOfRedeemableItem $items
     */
    public function __construct(\ArrayType\ArrayOfRedeemableItem $items = null)
    {
        $this
            ->setItems($items);
    }
    /**
     * Get Items value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfRedeemableItem|null
     */
    public function getItems()
    {
        return isset($this->Items) ? $this->Items : null;
    }
    /**
     * Set Items value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfRedeemableItem $items
     * @return \StructType\RedeemableItemsResponse
     */
    public function setItems(\ArrayType\ArrayOfRedeemableItem $items = null)
    {
        if (is_null($items) || (is_array($items) && empty($items))) {
            unset($this->Items);
        } else {
            $this->Items = $items;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RedeemableItemsResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
