<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RedeemableItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RedeemableItem
 * @subpackage Structs
 */
class RedeemableItem extends AbstractStructBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The Enabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Enabled;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The Image
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Image;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The PhysicalItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $PhysicalItem;
    /**
     * The ProvisioningAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ProvisioningAmount;
    /**
     * The ProvisioningPlatformCodeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ProvisioningPlatformCodeId;
    /**
     * The RedeemableItemCatalogue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RedeemableItemCatalogue
     */
    public $RedeemableItemCatalogue;
    /**
     * The RedeemableItemCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RedeemableItemCategory
     */
    public $RedeemableItemCategory;
    /**
     * The RedeemableItemExternalReferenceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RedeemableItemExternalReferenceId;
    /**
     * The RedeemableItemPrices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfRedeemableItemPrice
     */
    public $RedeemableItemPrices;
    /**
     * Constructor method for RedeemableItem
     * @uses RedeemableItem::setDescription()
     * @uses RedeemableItem::setEnabled()
     * @uses RedeemableItem::setId()
     * @uses RedeemableItem::setImage()
     * @uses RedeemableItem::setName()
     * @uses RedeemableItem::setPhysicalItem()
     * @uses RedeemableItem::setProvisioningAmount()
     * @uses RedeemableItem::setProvisioningPlatformCodeId()
     * @uses RedeemableItem::setRedeemableItemCatalogue()
     * @uses RedeemableItem::setRedeemableItemCategory()
     * @uses RedeemableItem::setRedeemableItemExternalReferenceId()
     * @uses RedeemableItem::setRedeemableItemPrices()
     * @param string $description
     * @param bool $enabled
     * @param int $id
     * @param string $image
     * @param string $name
     * @param bool $physicalItem
     * @param float $provisioningAmount
     * @param int $provisioningPlatformCodeId
     * @param \StructType\RedeemableItemCatalogue $redeemableItemCatalogue
     * @param \StructType\RedeemableItemCategory $redeemableItemCategory
     * @param int $redeemableItemExternalReferenceId
     * @param \ArrayType\ArrayOfRedeemableItemPrice $redeemableItemPrices
     */
    public function __construct($description = null, $enabled = null, $id = null, $image = null, $name = null, $physicalItem = null, $provisioningAmount = null, $provisioningPlatformCodeId = null, \StructType\RedeemableItemCatalogue $redeemableItemCatalogue = null, \StructType\RedeemableItemCategory $redeemableItemCategory = null, $redeemableItemExternalReferenceId = null, \ArrayType\ArrayOfRedeemableItemPrice $redeemableItemPrices = null)
    {
        $this
            ->setDescription($description)
            ->setEnabled($enabled)
            ->setId($id)
            ->setImage($image)
            ->setName($name)
            ->setPhysicalItem($physicalItem)
            ->setProvisioningAmount($provisioningAmount)
            ->setProvisioningPlatformCodeId($provisioningPlatformCodeId)
            ->setRedeemableItemCatalogue($redeemableItemCatalogue)
            ->setRedeemableItemCategory($redeemableItemCategory)
            ->setRedeemableItemExternalReferenceId($redeemableItemExternalReferenceId)
            ->setRedeemableItemPrices($redeemableItemPrices);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\RedeemableItem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Enabled value
     * @return bool|null
     */
    public function getEnabled()
    {
        return $this->Enabled;
    }
    /**
     * Set Enabled value
     * @param bool $enabled
     * @return \StructType\RedeemableItem
     */
    public function setEnabled($enabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($enabled) && !is_bool($enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enabled, true), gettype($enabled)), __LINE__);
        }
        $this->Enabled = $enabled;
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\RedeemableItem
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Image value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImage()
    {
        return isset($this->Image) ? $this->Image : null;
    }
    /**
     * Set Image value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $image
     * @return \StructType\RedeemableItem
     */
    public function setImage($image = null)
    {
        // validation for constraint: string
        if (!is_null($image) && !is_string($image)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($image, true), gettype($image)), __LINE__);
        }
        if (is_null($image) || (is_array($image) && empty($image))) {
            unset($this->Image);
        } else {
            $this->Image = $image;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\RedeemableItem
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get PhysicalItem value
     * @return bool|null
     */
    public function getPhysicalItem()
    {
        return $this->PhysicalItem;
    }
    /**
     * Set PhysicalItem value
     * @param bool $physicalItem
     * @return \StructType\RedeemableItem
     */
    public function setPhysicalItem($physicalItem = null)
    {
        // validation for constraint: boolean
        if (!is_null($physicalItem) && !is_bool($physicalItem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($physicalItem, true), gettype($physicalItem)), __LINE__);
        }
        $this->PhysicalItem = $physicalItem;
        return $this;
    }
    /**
     * Get ProvisioningAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getProvisioningAmount()
    {
        return isset($this->ProvisioningAmount) ? $this->ProvisioningAmount : null;
    }
    /**
     * Set ProvisioningAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $provisioningAmount
     * @return \StructType\RedeemableItem
     */
    public function setProvisioningAmount($provisioningAmount = null)
    {
        // validation for constraint: float
        if (!is_null($provisioningAmount) && !(is_float($provisioningAmount) || is_numeric($provisioningAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($provisioningAmount, true), gettype($provisioningAmount)), __LINE__);
        }
        if (is_null($provisioningAmount) || (is_array($provisioningAmount) && empty($provisioningAmount))) {
            unset($this->ProvisioningAmount);
        } else {
            $this->ProvisioningAmount = $provisioningAmount;
        }
        return $this;
    }
    /**
     * Get ProvisioningPlatformCodeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getProvisioningPlatformCodeId()
    {
        return isset($this->ProvisioningPlatformCodeId) ? $this->ProvisioningPlatformCodeId : null;
    }
    /**
     * Set ProvisioningPlatformCodeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $provisioningPlatformCodeId
     * @return \StructType\RedeemableItem
     */
    public function setProvisioningPlatformCodeId($provisioningPlatformCodeId = null)
    {
        // validation for constraint: int
        if (!is_null($provisioningPlatformCodeId) && !(is_int($provisioningPlatformCodeId) || ctype_digit($provisioningPlatformCodeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($provisioningPlatformCodeId, true), gettype($provisioningPlatformCodeId)), __LINE__);
        }
        if (is_null($provisioningPlatformCodeId) || (is_array($provisioningPlatformCodeId) && empty($provisioningPlatformCodeId))) {
            unset($this->ProvisioningPlatformCodeId);
        } else {
            $this->ProvisioningPlatformCodeId = $provisioningPlatformCodeId;
        }
        return $this;
    }
    /**
     * Get RedeemableItemCatalogue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RedeemableItemCatalogue|null
     */
    public function getRedeemableItemCatalogue()
    {
        return isset($this->RedeemableItemCatalogue) ? $this->RedeemableItemCatalogue : null;
    }
    /**
     * Set RedeemableItemCatalogue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RedeemableItemCatalogue $redeemableItemCatalogue
     * @return \StructType\RedeemableItem
     */
    public function setRedeemableItemCatalogue(\StructType\RedeemableItemCatalogue $redeemableItemCatalogue = null)
    {
        if (is_null($redeemableItemCatalogue) || (is_array($redeemableItemCatalogue) && empty($redeemableItemCatalogue))) {
            unset($this->RedeemableItemCatalogue);
        } else {
            $this->RedeemableItemCatalogue = $redeemableItemCatalogue;
        }
        return $this;
    }
    /**
     * Get RedeemableItemCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RedeemableItemCategory|null
     */
    public function getRedeemableItemCategory()
    {
        return isset($this->RedeemableItemCategory) ? $this->RedeemableItemCategory : null;
    }
    /**
     * Set RedeemableItemCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RedeemableItemCategory $redeemableItemCategory
     * @return \StructType\RedeemableItem
     */
    public function setRedeemableItemCategory(\StructType\RedeemableItemCategory $redeemableItemCategory = null)
    {
        if (is_null($redeemableItemCategory) || (is_array($redeemableItemCategory) && empty($redeemableItemCategory))) {
            unset($this->RedeemableItemCategory);
        } else {
            $this->RedeemableItemCategory = $redeemableItemCategory;
        }
        return $this;
    }
    /**
     * Get RedeemableItemExternalReferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRedeemableItemExternalReferenceId()
    {
        return isset($this->RedeemableItemExternalReferenceId) ? $this->RedeemableItemExternalReferenceId : null;
    }
    /**
     * Set RedeemableItemExternalReferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $redeemableItemExternalReferenceId
     * @return \StructType\RedeemableItem
     */
    public function setRedeemableItemExternalReferenceId($redeemableItemExternalReferenceId = null)
    {
        // validation for constraint: int
        if (!is_null($redeemableItemExternalReferenceId) && !(is_int($redeemableItemExternalReferenceId) || ctype_digit($redeemableItemExternalReferenceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($redeemableItemExternalReferenceId, true), gettype($redeemableItemExternalReferenceId)), __LINE__);
        }
        if (is_null($redeemableItemExternalReferenceId) || (is_array($redeemableItemExternalReferenceId) && empty($redeemableItemExternalReferenceId))) {
            unset($this->RedeemableItemExternalReferenceId);
        } else {
            $this->RedeemableItemExternalReferenceId = $redeemableItemExternalReferenceId;
        }
        return $this;
    }
    /**
     * Get RedeemableItemPrices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfRedeemableItemPrice|null
     */
    public function getRedeemableItemPrices()
    {
        return isset($this->RedeemableItemPrices) ? $this->RedeemableItemPrices : null;
    }
    /**
     * Set RedeemableItemPrices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfRedeemableItemPrice $redeemableItemPrices
     * @return \StructType\RedeemableItem
     */
    public function setRedeemableItemPrices(\ArrayType\ArrayOfRedeemableItemPrice $redeemableItemPrices = null)
    {
        if (is_null($redeemableItemPrices) || (is_array($redeemableItemPrices) && empty($redeemableItemPrices))) {
            unset($this->RedeemableItemPrices);
        } else {
            $this->RedeemableItemPrices = $redeemableItemPrices;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RedeemableItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
